/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.db;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.Properties;
import java.util.UUID;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSourceFactory.class);

    public static HikariDataSource createDataSource(String jdbcUrl, String username, String password) {
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(jdbcUrl);
        if (username != null && !username.isEmpty()) {
            config.setUsername(username);
        }
        if (password != null && !password.isEmpty()) {
            config.setPassword(password);
        }
        config.setMaximumPoolSize(DataSourceFactory.getIntProperty("wallet.db.pool.maximumPoolSize", 10));
        config.setMinimumIdle(DataSourceFactory.getIntProperty("wallet.db.pool.minimumIdle", 2));
        config.setConnectionTimeout(DataSourceFactory.getLongProperty("wallet.db.pool.connectionTimeout", 30000L));
        config.setIdleTimeout(DataSourceFactory.getLongProperty("wallet.db.pool.idleTimeout", 600000L));
        config.setMaxLifetime(DataSourceFactory.getLongProperty("wallet.db.pool.maxLifetime", 1800000L));
        config.setLeakDetectionThreshold(DataSourceFactory.getLongProperty("wallet.db.pool.leakDetectionThreshold", 60000L));
        config.setConnectionTestQuery(DataSourceFactory.getProperty("wallet.db.pool.connectionTestQuery", null));
        String basePoolName = DataSourceFactory.getProperty("wallet.db.pool.name", "CashuWalletPool");
        boolean uniqueName = DataSourceFactory.getBooleanProperty("wallet.db.pool.uniqueName", false);
        Object finalPoolName = basePoolName;
        if (uniqueName) {
            String suffix = UUID.randomUUID().toString().substring(0, 8);
            finalPoolName = basePoolName + "-" + suffix;
        }
        config.setRegisterMbeans(DataSourceFactory.getBooleanProperty("wallet.db.pool.registerMbeans", true));
        if (jdbcUrl.startsWith("jdbc:h2:")) {
            Properties h2Props = new Properties();
            config.setAutoCommit(false);
            h2Props.setProperty("DB_CLOSE_DELAY", "-1");
            h2Props.setProperty("MODE", "PostgreSQL");
            config.setDataSourceProperties(h2Props);
            if (!uniqueName) {
                String suffix = Long.toHexString(System.nanoTime());
                finalPoolName = basePoolName + "-" + suffix;
            }
            config.setRegisterMbeans(false);
            LOGGER.info("datasource_factory h2_optimizations_applied jdbc_url={}", (Object)jdbcUrl);
        }
        config.setPoolName((String)finalPoolName);
        HikariDataSource dataSource = new HikariDataSource(config);
        LOGGER.info("datasource_factory pool_created pool_name={} jdbc_url={} max_pool_size={} min_idle={} connection_timeout_ms={} leak_detection_threshold_ms={}", config.getPoolName(), jdbcUrl, config.getMaximumPoolSize(), config.getMinimumIdle(), config.getConnectionTimeout(), config.getLeakDetectionThreshold());
        return dataSource;
    }

    public static HikariDataSource createDataSource(String jdbcUrl) {
        return DataSourceFactory.createDataSource(jdbcUrl, null, null);
    }

    public static void shutdown(DataSource dataSource) {
        if (dataSource instanceof HikariDataSource) {
            HikariDataSource hikariDataSource = (HikariDataSource)dataSource;
            String poolName = hikariDataSource.getPoolName();
            LOGGER.info("datasource_factory shutdown_initiated pool_name={}", (Object)poolName);
            hikariDataSource.close();
            LOGGER.info("datasource_factory shutdown_completed pool_name={}", (Object)poolName);
        }
    }

    private static String getProperty(String key, String defaultValue) {
        String value = System.getProperty(key);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        String envKey = key.replace('.', '_').toUpperCase();
        value = System.getenv(envKey);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        return defaultValue;
    }

    private static int getIntProperty(String key, int defaultValue) {
        String value = DataSourceFactory.getProperty(key, null);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            LOGGER.warn("datasource_factory invalid_int_property key={} value={} using_default={}", key, value, defaultValue);
            return defaultValue;
        }
    }

    private static long getLongProperty(String key, long defaultValue) {
        String value = DataSourceFactory.getProperty(key, null);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            LOGGER.warn("datasource_factory invalid_long_property key={} value={} using_default={}", key, value, defaultValue);
            return defaultValue;
        }
    }

    private static boolean getBooleanProperty(String key, boolean defaultValue) {
        String value = DataSourceFactory.getProperty(key, null);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }
}

