/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.wallet.core.WalletStorageException;
import xyz.tcheeric.wallet.core.proof.NewProof;
import xyz.tcheeric.wallet.core.proof.ProofRecord;
import xyz.tcheeric.wallet.core.proof.ProofSummary;
import xyz.tcheeric.wallet.core.security.EncryptionException;
import xyz.tcheeric.wallet.core.security.EncryptionService;

public class ProofRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProofRepository.class);
    private final DataSource dataSource;
    private final String jdbcUrl;
    private final String user;
    private final String pass;
    private final EncryptionService encryptionService;

    public ProofRepository(DataSource dataSource, EncryptionService encryptionService) {
        this.dataSource = dataSource;
        this.jdbcUrl = null;
        this.user = null;
        this.pass = null;
        this.encryptionService = encryptionService;
        LOGGER.info("proof_repository initialized with_connection_pooling=true");
    }

    @Deprecated(since="1.0.0-RC1", forRemoval=true)
    public ProofRepository(String jdbcUrl, String user, String pass, EncryptionService encryptionService) {
        this.dataSource = null;
        this.jdbcUrl = jdbcUrl;
        this.user = user;
        this.pass = pass;
        this.encryptionService = encryptionService;
        LOGGER.warn("proof_repository initialized with_connection_pooling=false performance_impact=high recommendation=use_datasource_constructor_with_hikaricp");
    }

    private Connection getConnection() throws SQLException {
        if (this.dataSource != null) {
            return this.dataSource.getConnection();
        }
        return DriverManager.getConnection(this.jdbcUrl, this.user, this.pass);
    }

    public List<ProofRecord> listProofs(String unit, String mintUrl) {
        ArrayList<ProofRecord> rows = new ArrayList<ProofRecord>();
        String context = ProofRepository.buildContext("unit=" + unit, "mint=" + mintUrl);
        LOGGER.debug("proof_repository list_attempt {}", (Object)context);
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement("SELECT id, mint_url, unit, amount, C, secret_enc, keyset_id FROM proofs WHERE spent=FALSE AND unit=? AND mint_url=? ORDER BY amount DESC");){
            statement.setString(1, unit);
            statement.setString(2, mintUrl);
            try (ResultSet rs = statement.executeQuery();){
                while (rs.next()) {
                    long id = rs.getLong(1);
                    String mu = rs.getString(2);
                    String u = rs.getString(3);
                    int amt = rs.getInt(4);
                    String cHex = rs.getString(5);
                    byte[] secret = rs.getBytes(6);
                    try {
                        secret = this.encryptionService.decrypt(secret);
                    }
                    catch (EncryptionException encryptionException) {
                        // empty catch block
                    }
                    String keysetId = rs.getString(7);
                    rows.add(new ProofRecord(id, mu, u, amt, cHex, secret, keysetId));
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("proof_repository list_failed {} sql_state={} error_code={} message={}", context, ProofRepository.safeSqlState(e), e.getErrorCode(), e.getMessage(), e);
            throw this.storageException("list", e, context);
        }
        LOGGER.debug("proof_repository list_success {} proof_count={}", (Object)context, (Object)rows.size());
        return rows;
    }

    public List<ProofSummary> listProofSummaries(String unit, String mintUrl, Integer minAmount, Integer maxAmount, String keysetId, boolean includeSpent, int limit) {
        ArrayList<ProofSummary> out = new ArrayList<ProofSummary>();
        int remaining = limit <= 0 ? Integer.MAX_VALUE : limit;
        String context = ProofRepository.buildContext(new String[]{"unit=" + unit, "mint=" + mintUrl, includeSpent ? "include_spent=true" : "include_spent=false", limit > 0 ? "limit=" + limit : "limit=unbounded", minAmount != null ? "min_amount=" + minAmount : null, maxAmount != null ? "max_amount=" + maxAmount : null, keysetId != null && !keysetId.isBlank() ? "keyset=" + keysetId : null});
        LOGGER.debug("proof_repository list_summary_attempt {}", (Object)context);
        StringBuilder sql = new StringBuilder("SELECT amount, C, keyset_id, spent, created_at FROM proofs WHERE unit=? AND mint_url=?");
        if (!includeSpent) {
            sql.append(" AND spent=FALSE");
        }
        if (minAmount != null) {
            sql.append(" AND amount>=?");
        }
        if (maxAmount != null) {
            sql.append(" AND amount<=?");
        }
        if (keysetId != null && !keysetId.isBlank()) {
            sql.append(" AND keyset_id=?");
        }
        sql.append(" ORDER BY amount DESC, id DESC");
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql.toString());){
            int idx = 0;
            statement.setString(++idx, unit);
            statement.setString(++idx, mintUrl);
            if (minAmount != null) {
                statement.setInt(++idx, minAmount);
            }
            if (maxAmount != null) {
                statement.setInt(++idx, maxAmount);
            }
            if (keysetId != null && !keysetId.isBlank()) {
                statement.setString(++idx, keysetId);
            }
            try (ResultSet rs = statement.executeQuery();){
                while (rs.next() && remaining-- > 0) {
                    int amt = rs.getInt(1);
                    String cHex = rs.getString(2);
                    String keyset = rs.getString(3);
                    boolean spent = rs.getBoolean(4);
                    Timestamp created = rs.getTimestamp(5);
                    out.add(new ProofSummary(amt, keyset, cHex, spent, created == null ? null : created.toInstant()));
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("proof_repository list_summary_failed {} sql_state={} error_code={} message={}", context, ProofRepository.safeSqlState(e), e.getErrorCode(), e.getMessage(), e);
            throw this.storageException("list_summary", e, context);
        }
        LOGGER.debug("proof_repository list_summary_success {} proof_count={}", (Object)context, (Object)out.size());
        return out;
    }

    public void persistProofs(String mintUrl, String unit, List<NewProof> proofs) {
        String context = ProofRepository.buildContext("mint=" + mintUrl, "unit=" + unit, "proof_count=" + proofs.size());
        LOGGER.debug("proof_repository persist_attempt {}", (Object)context);
        try (Connection connection = this.getConnection();){
            connection.setAutoCommit(false);
            this.persistProofsInternal(connection, mintUrl, unit, proofs);
            connection.commit();
        }
        catch (SQLException e) {
            LOGGER.error("proof_repository persist_failed {} sql_state={} error_code={} message={}", context, ProofRepository.safeSqlState(e), e.getErrorCode(), e.getMessage(), e);
            throw this.storageException("persist", e, context);
        }
        LOGGER.debug("proof_repository persist_success {}", (Object)context);
    }

    public void persistProofs(Connection connection, String mintUrl, String unit, List<NewProof> proofs) throws SQLException {
        this.persistProofsInternal(connection, mintUrl, unit, proofs);
    }

    private void persistProofsInternal(Connection connection, String mintUrl, String unit, List<NewProof> proofs) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("INSERT INTO proofs (mint_url, unit, amount, C, secret_enc, keyset_id, spent) VALUES (?,?,?,?,?,?,FALSE)");){
            for (NewProof np : proofs) {
                int idx = 0;
                statement.setString(++idx, mintUrl);
                statement.setString(++idx, unit);
                statement.setInt(++idx, np.amount());
                statement.setString(++idx, np.cHex());
                statement.setBytes(++idx, np.secret());
                statement.setString(++idx, np.keysetId());
                statement.addBatch();
            }
            statement.executeBatch();
        }
    }

    public void markProofsSpent(String mintUrl, String unit, List<NewProof> proofs) {
        String context = ProofRepository.buildContext("mint=" + mintUrl, "unit=" + unit, "proof_count=" + proofs.size());
        LOGGER.debug("proof_repository mark_melted_attempt {}", (Object)context);
        try (Connection connection = this.getConnection();){
            connection.setAutoCommit(false);
            try (PreparedStatement statement = connection.prepareStatement("UPDATE proofs SET spent=TRUE, spent_at=CURRENT_TIMESTAMP WHERE mint_url=? AND unit=? AND amount=? AND C=? AND keyset_id=? AND spent=FALSE");){
                for (NewProof np : proofs) {
                    int idx = 0;
                    statement.setString(++idx, mintUrl);
                    statement.setString(++idx, unit);
                    statement.setInt(++idx, np.amount());
                    statement.setString(++idx, np.cHex());
                    statement.setString(++idx, np.keysetId());
                    statement.addBatch();
                }
                statement.executeBatch();
            }
            connection.commit();
        }
        catch (SQLException e) {
            LOGGER.error("proof_repository mark_melted_failed {} sql_state={} error_code={} message={}", context, ProofRepository.safeSqlState(e), e.getErrorCode(), e.getMessage(), e);
            throw this.storageException("mark_melted", e, context);
        }
        LOGGER.debug("proof_repository mark_melted_success {}", (Object)context);
    }

    public void markProofsAsSpent(List<ProofRecord> toMark) {
        String context = ProofRepository.buildContext("proof_count=" + toMark.size());
        LOGGER.debug("proof_repository mark_spent_attempt {}", (Object)context);
        try (Connection connection = this.getConnection();){
            connection.setAutoCommit(false);
            try (PreparedStatement statement = connection.prepareStatement("UPDATE proofs SET spent=TRUE, spent_at=CURRENT_TIMESTAMP WHERE id=? AND spent=FALSE");){
                for (ProofRecord r : toMark) {
                    statement.setLong(1, r.id());
                    statement.addBatch();
                }
                statement.executeBatch();
            }
            connection.commit();
        }
        catch (SQLException e) {
            LOGGER.error("proof_repository mark_spent_failed {} sql_state={} error_code={} message={}", context, ProofRepository.safeSqlState(e), e.getErrorCode(), e.getMessage(), e);
            throw this.storageException("mark_spent", e, context);
        }
        LOGGER.debug("proof_repository mark_spent_success {}", (Object)context);
    }

    /*
     * Exception decompiling
     */
    public ImportResult importProofs(String mintUrl, String unit, List<NewProof> proofs) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String buildContext(String ... entries) {
        StringJoiner joiner = new StringJoiner(" ");
        for (String entry : entries) {
            if (entry == null || entry.isBlank()) continue;
            joiner.add(entry);
        }
        return joiner.toString();
    }

    private static String safeSqlState(SQLException e) {
        String sqlState = e.getSQLState();
        return sqlState == null ? "n/a" : sqlState;
    }

    private WalletStorageException storageException(String operation, SQLException e, String context) {
        String trimmed = context == null ? "" : context.trim();
        StringBuilder message = new StringBuilder("proof_repository ").append(operation).append("_failed");
        if (!trimmed.isEmpty()) {
            message.append(' ').append(trimmed);
        }
        message.append(" sql_state=").append(ProofRepository.safeSqlState(e)).append(" error_code=").append(e.getErrorCode());
        return new WalletStorageException(message.toString(), e);
    }

    public record ImportResult(List<Integer> insertedIndexes, List<Integer> duplicateIndexes) {
        public ImportResult {
            insertedIndexes = Collections.unmodifiableList(new ArrayList<Integer>(insertedIndexes));
            duplicateIndexes = Collections.unmodifiableList(new ArrayList<Integer>(duplicateIndexes));
        }
    }

    private record ProofDedupKey(String mintUrl, String unit, int amount, String cHex, String keysetId) {
    }
}

