/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.domain;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.wallet.core.WalletStorageException;
import xyz.tcheeric.wallet.core.db.ProofRepository;
import xyz.tcheeric.wallet.core.domain.WalletAggregate;
import xyz.tcheeric.wallet.core.proof.NewProof;
import xyz.tcheeric.wallet.core.proof.ProofRecord;

public class WalletAggregateRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(WalletAggregateRepository.class);
    private final DataSource dataSource;
    private final ProofRepository proofRepository;

    public WalletAggregateRepository(DataSource dataSource, ProofRepository proofRepository) {
        this.dataSource = Objects.requireNonNull(dataSource, "dataSource");
        this.proofRepository = Objects.requireNonNull(proofRepository, "proofRepository");
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public WalletAggregate loadOrCreate(String walletId, String mintUrl, String unit) {
        LOGGER.debug("wallet_aggregate_repository load_attempt wallet_id={} mint={} unit={}", walletId, mintUrl, unit);
        try (Connection conn = this.dataSource.getConnection();){
            conn.setAutoCommit(false);
            try {
                long version;
                this.ensureMetadataTable(conn);
                Optional<WalletMetadata> metadata = this.loadMetadata(conn, walletId, mintUrl, unit);
                if (metadata.isEmpty()) {
                    version = this.insertMetadata(conn, walletId, mintUrl, unit);
                    LOGGER.info("wallet_aggregate_repository created wallet_id={} mint={} unit={} version={}", walletId, mintUrl, unit, version);
                } else {
                    version = metadata.get().version();
                    LOGGER.debug("wallet_aggregate_repository loaded wallet_id={} mint={} unit={} version={}", walletId, mintUrl, unit, version);
                }
                conn.commit();
                WalletAggregate aggregate = new WalletAggregate(walletId, mintUrl, unit, version);
                List<ProofRecord> proofs = this.proofRepository.listProofs(unit, mintUrl);
                aggregate.loadProofs(proofs);
                LOGGER.debug("wallet_aggregate_repository load_success wallet_id={} proof_count={}", (Object)walletId, (Object)proofs.size());
                WalletAggregate walletAggregate = aggregate;
                return walletAggregate;
            }
            catch (SQLException e) {
                try {
                    conn.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw e;
            }
            finally {
                try {
                    conn.setAutoCommit(true);
                }
                catch (SQLException sQLException) {}
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("wallet_aggregate_repository load_failed wallet_id={} mint={} unit={} sql_state={} error={}", walletId, mintUrl, unit, WalletAggregateRepository.safeSqlState(e), e.getMessage(), e);
            throw new WalletStorageException("Failed to load wallet aggregate. Database operation failed: " + e.getMessage() + ". Suggestion: Verify database connectivity and credentials, then retry the operation.", e);
        }
    }

    public void save(WalletAggregate aggregate, List<NewProof> newProofs) {
        LOGGER.debug("wallet_aggregate_repository save_attempt wallet_id={} version={} new_proofs={}", aggregate.getWalletId(), aggregate.getVersion(), newProofs.size());
        try (Connection conn = this.dataSource.getConnection();){
            conn.setAutoCommit(false);
            try {
                long currentVersion = aggregate.getVersion();
                long newVersion = currentVersion + 1L;
                int updated = this.updateVersion(conn, aggregate.getWalletId(), aggregate.getMintUrl(), aggregate.getUnit(), currentVersion, newVersion);
                if (updated == 0) {
                    throw new OptimisticLockException(String.format("Optimistic lock failure for wallet %s (mint=%s, unit=%s, version=%d)", aggregate.getWalletId(), aggregate.getMintUrl(), aggregate.getUnit(), currentVersion));
                }
                if (!newProofs.isEmpty()) {
                    this.proofRepository.persistProofs(conn, aggregate.getMintUrl(), aggregate.getUnit(), newProofs);
                }
                conn.commit();
                aggregate.incrementVersion();
                LOGGER.info("wallet_aggregate_repository save_success wallet_id={} version={} new_proofs={}", aggregate.getWalletId(), newVersion, newProofs.size());
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        catch (SQLException e) {
            LOGGER.error("wallet_aggregate_repository save_failed wallet_id={} version={} sql_state={} error={}", aggregate.getWalletId(), aggregate.getVersion(), WalletAggregateRepository.safeSqlState(e), e.getMessage(), e);
            throw new WalletStorageException("Failed to save wallet aggregate. Database operation failed: " + e.getMessage() + ". Suggestion: Verify database connectivity and credentials, then retry the operation.", e);
        }
    }

    public void markProofsSpent(WalletAggregate aggregate, List<ProofRecord> proofs) {
        LOGGER.debug("wallet_aggregate_repository mark_spent_attempt wallet_id={} proof_count={}", (Object)aggregate.getWalletId(), (Object)proofs.size());
        try {
            this.proofRepository.markProofsAsSpent(proofs);
            LOGGER.info("wallet_aggregate_repository mark_spent_success wallet_id={} proof_count={}", (Object)aggregate.getWalletId(), (Object)proofs.size());
        }
        catch (WalletStorageException e) {
            LOGGER.error("wallet_aggregate_repository mark_spent_failed wallet_id={} proof_count={} error={}", aggregate.getWalletId(), proofs.size(), e.getMessage(), e);
            throw e;
        }
    }

    private void ensureMetadataTable(Connection conn) throws SQLException {
        String ddl = "CREATE TABLE IF NOT EXISTS wallet_metadata (\n    wallet_id VARCHAR(255) NOT NULL,\n    mint_url VARCHAR(1024) NOT NULL,\n    unit VARCHAR(64) NOT NULL,\n    version BIGINT NOT NULL DEFAULT 0,\n    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,\n    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,\n    PRIMARY KEY (wallet_id, mint_url, unit)\n)\n";
        try (PreparedStatement stmt = conn.prepareStatement(ddl);){
            stmt.execute();
        }
    }

    private Optional<WalletMetadata> loadMetadata(Connection conn, String walletId, String mintUrl, String unit) throws SQLException {
        String sql = "SELECT version FROM wallet_metadata WHERE wallet_id=? AND mint_url=? AND unit=?";
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, walletId);
            stmt.setString(2, mintUrl);
            stmt.setString(3, unit);
            try (ResultSet rs = stmt.executeQuery();){
                if (rs.next()) {
                    Optional<WalletMetadata> optional = Optional.of(new WalletMetadata(walletId, mintUrl, unit, rs.getLong("version")));
                    return optional;
                }
            }
        }
        return Optional.empty();
    }

    private long insertMetadata(Connection conn, String walletId, String mintUrl, String unit) throws SQLException {
        String sql = "INSERT INTO wallet_metadata (wallet_id, mint_url, unit, version) VALUES (?, ?, ?, 0)";
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, walletId);
            stmt.setString(2, mintUrl);
            stmt.setString(3, unit);
            stmt.executeUpdate();
            long l = 0L;
            return l;
        }
    }

    private int updateVersion(Connection conn, String walletId, String mintUrl, String unit, long expectedVersion, long newVersion) throws SQLException {
        String sql = "UPDATE wallet_metadata\nSET version = ?, updated_at = CURRENT_TIMESTAMP\nWHERE wallet_id = ? AND mint_url = ? AND unit = ? AND version = ?\n";
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setLong(1, newVersion);
            stmt.setString(2, walletId);
            stmt.setString(3, mintUrl);
            stmt.setString(4, unit);
            stmt.setLong(5, expectedVersion);
            int n = stmt.executeUpdate();
            return n;
        }
    }

    private static String safeSqlState(SQLException e) {
        String sqlState = e.getSQLState();
        return sqlState == null ? "n/a" : sqlState;
    }

    private record WalletMetadata(String walletId, String mintUrl, String unit, long version) {
    }

    public static class OptimisticLockException
    extends RuntimeException {
        public OptimisticLockException(String message) {
            super(message);
        }
    }
}

