/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.exception;

import xyz.tcheeric.wallet.core.exception.WalletOperationException;

public final class ProofImportException
extends WalletOperationException {
    private static final String DEFAULT_STORAGE_SUGGESTION = "Check available disk space and file permissions. If the error persists, try restarting the wallet.";
    private static final String DEFAULT_INVALID_DATA_SUGGESTION = "Verify the token is valid and complete. Ensure you copied the entire token string without modifications.";
    private static final String DEFAULT_DECODE_SUGGESTION = "Ensure the token format is correct (should start with 'cashuA'). If you received this token from someone else, ask them to re-send it.";

    public ProofImportException(String userMessage) {
        super("PROOF_IMPORT_FAILED", false, userMessage, DEFAULT_STORAGE_SUGGESTION);
    }

    public ProofImportException(String userMessage, Throwable cause) {
        super("PROOF_IMPORT_FAILED", false, userMessage, DEFAULT_STORAGE_SUGGESTION, cause);
    }

    public ProofImportException(String userMessage, String suggestion) {
        super("PROOF_IMPORT_FAILED", false, userMessage, suggestion);
    }

    public ProofImportException(String userMessage, String suggestion, Throwable cause) {
        super("PROOF_IMPORT_FAILED", false, userMessage, suggestion, cause);
    }

    public static ProofImportException forStorageFailure(String mintUrl, Throwable cause) {
        return new ProofImportException("Failed to persist proofs imported from " + mintUrl, DEFAULT_STORAGE_SUGGESTION, cause);
    }

    public static ProofImportException forInvalidData(String mintUrl) {
        return new ProofImportException("Invalid proof import data received from " + mintUrl, DEFAULT_INVALID_DATA_SUGGESTION);
    }

    public static ProofImportException forDecodingFailure(String error) {
        return new ProofImportException("Failed to decode token payload: " + error, DEFAULT_DECODE_SUGGESTION);
    }
}

