/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.exception;

import java.time.Instant;
import xyz.tcheeric.wallet.core.exception.WalletOperationException;

public final class QuoteExpiredException
extends WalletOperationException {
    private static final String DEFAULT_SUGGESTION = "Request a new quote and complete the payment within 5 minutes. Mint quotes typically expire after 300 seconds of inactivity.";
    private final String reference;
    private final Instant expiredAt;

    public QuoteExpiredException(String reference, Instant expiredAt, String userMessage) {
        super("QUOTE_EXPIRED", false, userMessage, DEFAULT_SUGGESTION);
        this.reference = reference;
        this.expiredAt = expiredAt;
    }

    public QuoteExpiredException(String reference, Instant expiredAt, String userMessage, Throwable cause) {
        super("QUOTE_EXPIRED", false, userMessage, DEFAULT_SUGGESTION, cause);
        this.reference = reference;
        this.expiredAt = expiredAt;
    }

    public QuoteExpiredException(String reference, Instant expiredAt, String userMessage, String suggestion) {
        super("QUOTE_EXPIRED", false, userMessage, suggestion);
        this.reference = reference;
        this.expiredAt = expiredAt;
    }

    public QuoteExpiredException(String reference, Instant expiredAt, String userMessage, String suggestion, Throwable cause) {
        super("QUOTE_EXPIRED", false, userMessage, suggestion, cause);
        this.reference = reference;
        this.expiredAt = expiredAt;
    }

    public String getReference() {
        return this.reference;
    }

    public Instant getExpiredAt() {
        return this.expiredAt;
    }
}

