/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.exception;

import xyz.tcheeric.wallet.core.exception.WalletOperationException;

public final class VoucherBackupException
extends WalletOperationException {
    private static final String DEFAULT_SERIALIZATION_SUGGESTION = "Verify the voucher data is valid and not corrupted. If the issue persists, this may indicate a bug - please report it.";
    private static final String DEFAULT_DESERIALIZATION_SUGGESTION = "Verify the backup data is valid JSON and try again. If the issue persists, the backup may be from an incompatible version.";
    private static final String DEFAULT_ENCRYPTION_SUGGESTION = "Verify your wallet keys are valid. If the issue persists, contact support.";
    private static final String DEFAULT_DECRYPTION_SUGGESTION = "Verify you are using the correct wallet identity. If the backup was created with a different identity, restore that identity first.";
    private static final String DEFAULT_PUBLISH_SUGGESTION = "Check your internet connection and relay configuration. Retry the backup operation in a few moments.";
    private static final String DEFAULT_QUERY_SUGGESTION = "Check your internet connection and relay configuration. Ensure Nostr relays are accessible and retry.";

    public VoucherBackupException(String errorCode, boolean retryable, String userMessage, String suggestion) {
        super(errorCode, retryable, userMessage, suggestion);
    }

    public VoucherBackupException(String errorCode, boolean retryable, String userMessage, String suggestion, Throwable cause) {
        super(errorCode, retryable, userMessage, suggestion, cause);
    }

    public static VoucherBackupException forSerializationFailure(int voucherCount, Throwable cause) {
        return new VoucherBackupException("BACKUP_SERIALIZATION_FAILED", false, "Failed to serialize " + voucherCount + " vouchers to JSON", DEFAULT_SERIALIZATION_SUGGESTION, cause);
    }

    public static VoucherBackupException forDeserializationFailure(Throwable cause) {
        return new VoucherBackupException("BACKUP_DESERIALIZATION_FAILED", false, "Failed to deserialize voucher backup. Data may be corrupted.", DEFAULT_DESERIALIZATION_SUGGESTION, cause);
    }

    public static VoucherBackupException forEncryptionFailure(Throwable cause) {
        return new VoucherBackupException("BACKUP_ENCRYPTION_FAILED", false, "Failed to encrypt voucher backup using NIP-44.", DEFAULT_ENCRYPTION_SUGGESTION, cause);
    }

    public static VoucherBackupException forDecryptionFailure(Throwable cause) {
        return new VoucherBackupException("BACKUP_DECRYPTION_FAILED", false, "Failed to decrypt voucher backup. Wrong key or corrupted data.", DEFAULT_DECRYPTION_SUGGESTION, cause);
    }

    public static VoucherBackupException forPublishFailure(String reason, boolean retryable) {
        return new VoucherBackupException("BACKUP_PUBLISH_FAILED", retryable, "Failed to publish voucher backup to Nostr relays. " + reason, DEFAULT_PUBLISH_SUGGESTION);
    }

    public static VoucherBackupException forPublishFailure(String reason, boolean retryable, Throwable cause) {
        return new VoucherBackupException("BACKUP_PUBLISH_FAILED", retryable, "Failed to publish voucher backup: " + reason, DEFAULT_PUBLISH_SUGGESTION, cause);
    }

    public static VoucherBackupException forQueryFailure(String ownerPubkey, Throwable cause) {
        return new VoucherBackupException("BACKUP_QUERY_FAILED", true, "Failed to query voucher backups from Nostr relays for pubkey " + ownerPubkey, DEFAULT_QUERY_SUGGESTION, cause);
    }
}

