/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.exception;

import xyz.tcheeric.wallet.core.exception.WalletOperationException;

public final class VoucherImportException
extends WalletOperationException {
    private static final String DEFAULT_SUGGESTION = "Verify the voucher data is valid and the wallet is properly initialized. Check available disk space and file permissions.";
    private static final String INVALID_DATA_SUGGESTION = "The voucher data appears to be malformed or incomplete. Ensure you are importing from a valid voucher export file.";

    public VoucherImportException(String userMessage) {
        super("VOUCHER_IMPORT_FAILED", false, userMessage, DEFAULT_SUGGESTION);
    }

    public VoucherImportException(String userMessage, Throwable cause) {
        super("VOUCHER_IMPORT_FAILED", false, userMessage, DEFAULT_SUGGESTION, cause);
    }

    public VoucherImportException(String userMessage, String suggestion) {
        super("VOUCHER_IMPORT_FAILED", false, userMessage, suggestion);
    }

    public VoucherImportException(String userMessage, String suggestion, Throwable cause) {
        super("VOUCHER_IMPORT_FAILED", false, userMessage, suggestion, cause);
    }

    public static VoucherImportException forInvalidData(String voucherId) {
        return new VoucherImportException("Invalid voucher data for voucher ID: " + voucherId, INVALID_DATA_SUGGESTION);
    }

    public static VoucherImportException forStorageFailure(String voucherId, Throwable cause) {
        return new VoucherImportException("Failed to save voucher " + voucherId + " to wallet storage", DEFAULT_SUGGESTION, cause);
    }
}

