/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.exception;

import java.util.Objects;
import java.util.Optional;

public abstract class WalletOperationException
extends Exception {
    private final String errorCode;
    private final boolean retryable;
    private final String userMessage;
    private final String suggestion;

    protected WalletOperationException(String errorCode, boolean retryable, String userMessage) {
        this(errorCode, retryable, userMessage, null, null);
    }

    protected WalletOperationException(String errorCode, boolean retryable, String userMessage, Throwable cause) {
        this(errorCode, retryable, userMessage, null, cause);
    }

    protected WalletOperationException(String errorCode, boolean retryable, String userMessage, String suggestion) {
        this(errorCode, retryable, userMessage, suggestion, null);
    }

    protected WalletOperationException(String errorCode, boolean retryable, String userMessage, String suggestion, Throwable cause) {
        super(userMessage, cause);
        this.errorCode = Objects.requireNonNull(errorCode, "errorCode");
        this.retryable = retryable;
        this.userMessage = Objects.requireNonNull(userMessage, "userMessage");
        this.suggestion = suggestion;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public boolean isRetryable() {
        return this.retryable;
    }

    public String getUserMessage() {
        return this.userMessage;
    }

    public Optional<String> getSuggestion() {
        return Optional.ofNullable(this.suggestion);
    }

    public String getFormattedMessage() {
        if (this.suggestion != null && !this.suggestion.isBlank()) {
            return this.userMessage + ". Suggestion: " + this.suggestion;
        }
        return this.userMessage;
    }
}

