/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.melt;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.bouncycastle.math.ec.ECPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.common.ActiveKeySet;
import xyz.tcheeric.cashu.common.BlindSignature;
import xyz.tcheeric.cashu.common.BlindedMessage;
import xyz.tcheeric.cashu.common.HashToCurveSecret;
import xyz.tcheeric.cashu.common.KeySet;
import xyz.tcheeric.cashu.common.KeysetId;
import xyz.tcheeric.cashu.common.Proof;
import xyz.tcheeric.cashu.common.PublicKey;
import xyz.tcheeric.cashu.common.RandomStringSecret;
import xyz.tcheeric.cashu.common.Signature;
import xyz.tcheeric.cashu.crypto.BDHKEUtils;
import xyz.tcheeric.cashu.entities.rest.GetActiveKeySetsResponse;
import xyz.tcheeric.cashu.entities.rest.GetKeySetsResponse;
import xyz.tcheeric.cashu.entities.rest.PostCheckStateRequest;
import xyz.tcheeric.cashu.entities.rest.PostCheckStateResponse;
import xyz.tcheeric.cashu.entities.rest.PostMeltRequest;
import xyz.tcheeric.cashu.entities.rest.PostMeltResponse;
import xyz.tcheeric.cashu.entities.rest.PostSwapRequest;
import xyz.tcheeric.cashu.entities.rest.PostSwapResponse;
import xyz.tcheeric.wallet.core.MeltRequestContext;
import xyz.tcheeric.wallet.core.PollingConfig;
import xyz.tcheeric.wallet.core.api.MintApi;
import xyz.tcheeric.wallet.core.api.MintApiException;
import xyz.tcheeric.wallet.core.crypto.CryptoAdapter;
import xyz.tcheeric.wallet.core.db.ProofRepository;
import xyz.tcheeric.wallet.core.melt.InvalidChangeException;
import xyz.tcheeric.wallet.core.melt.LightningPaymentException;
import xyz.tcheeric.wallet.core.melt.MeltQuoteExpiredException;
import xyz.tcheeric.wallet.core.proof.NewProof;
import xyz.tcheeric.wallet.core.proof.ProofRecord;
import xyz.tcheeric.wallet.core.proof.ProofSelector;
import xyz.tcheeric.wallet.core.proof.Selection;
import xyz.tcheeric.wallet.core.security.EncryptionException;
import xyz.tcheeric.wallet.core.security.EncryptionService;
import xyz.tcheeric.wallet.core.util.HexCaseUtils;
import xyz.tcheeric.wallet.core.util.QuoteExpiryDetector;

public class MeltService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MeltService.class);
    private final MintApi mintApi;
    private final CryptoAdapter crypto;
    private final ProofRepository repository;
    private final EncryptionService encryptionService;

    public MeltService(MintApi mintApi, CryptoAdapter crypto, ProofRepository repository, EncryptionService encryptionService) {
        this.mintApi = mintApi;
        this.crypto = crypto;
        this.repository = repository;
        this.encryptionService = encryptionService;
    }

    public void melt(MeltRequestContext request) {
        List<NewProof> proofsForMelt;
        QuoteSelection qs = this.quoteAndSelectProofs(request);
        this.preSpendCheck(request, qs.selection());
        if (qs.selection().sum() > qs.target()) {
            proofsForMelt = this.swapForTarget(request, qs.selection(), qs.target());
        } else if (qs.selection().sum() == qs.target()) {
            proofsForMelt = this.selectionToProofs(qs.selection());
        } else {
            throw new IllegalStateException("Insufficient funds: have " + qs.selection().sum() + ", need " + qs.target());
        }
        this.executeMelt(request, qs.quote(), proofsForMelt);
        this.repository.markProofsSpent(request.mintUrl(), request.unit(), proofsForMelt);
    }

    private QuoteSelection quoteAndSelectProofs(MeltRequestContext request) {
        MintApi.MeltQuote quote = this.mintApi.quoteMelt(request.mintUrl(), request.unit(), request.amount(), request.invoice());
        long target = request.amount() + Math.max(0L, quote.feeReserve());
        List<ProofRecord> all = this.repository.listProofs(request.unit(), request.mintUrl());
        Selection selection = ProofSelector.selectExact(all, target).or(() -> ProofSelector.selectExactDP(all, target)).orElseGet(() -> this.selectProofsAtLeast(request.unit(), request.mintUrl(), target));
        return new QuoteSelection(quote, selection, target);
    }

    private void preSpendCheck(MeltRequestContext request, Selection selection) {
        if (!MeltService.useCheckBeforeSpend()) {
            return;
        }
        try {
            PostCheckStateRequest mintRequest = new PostCheckStateRequest(this.rowsToHashToCurve(selection.rows()));
            this.mintApi.check(request.mintUrl(), mintRequest);
        }
        catch (RuntimeException e) {
            log.warn("melt_service prespend_check_failed mint_url={} unit={} reason={} outcome=skipped_check", request.mintUrl(), request.unit(), e.getMessage(), e);
        }
    }

    private List<NewProof> swapForTarget(MeltRequestContext request, Selection selection, long target) {
        String mintUrl = request.mintUrl();
        String unit = request.unit();
        KeysetInfo keyset = this.lookupActiveKeyset(mintUrl, unit);
        List<Proof<RandomStringSecret>> inputs = this.prepareInputs(selection);
        SwapExecution exec = this.performSwap(mintUrl, keyset.keysetId(), selection.sum(), target, inputs);
        List<NewProof> newProofs = this.processSwapResults(exec, keyset);
        this.saveSwapResults(mintUrl, unit, selection, newProofs);
        return this.selectProofsForMelt(newProofs, target);
    }

    private KeysetInfo lookupActiveKeyset(String mintUrl, String unit) {
        GetActiveKeySetsResponse activeKeySetsResponse = this.mintApi.activeKeysets(mintUrl);
        String outKeysetId = activeKeySetsResponse.getActiveKeySets().stream().filter(k -> unit.equalsIgnoreCase(k.getUnit()) && k.isActive()).map(ActiveKeySet::getId).findFirst().orElseThrow(() -> new IllegalStateException("No active keyset for unit " + unit));
        GetKeySetsResponse keysetResp = this.mintApi.keyset(mintUrl, outKeysetId);
        KeySet keyset = keysetResp.getKeySets().stream().filter(k -> outKeysetId.equals(k.getId())).findFirst().orElseThrow();
        HashMap<Integer, byte[]> pubByAmount = new HashMap<Integer, byte[]>();
        for (Map.Entry<BigInteger, PublicKey> e : keyset.getKeys().getValues().entrySet()) {
            pubByAmount.put(e.getKey().intValue(), e.getValue().toBytes());
        }
        return new KeysetInfo(outKeysetId, pubByAmount);
    }

    private List<Proof<RandomStringSecret>> prepareInputs(Selection selection) {
        ArrayList<Proof<RandomStringSecret>> inputs = new ArrayList<Proof<RandomStringSecret>>();
        for (ProofRecord r : selection.rows()) {
            Proof<RandomStringSecret> proof = new Proof<RandomStringSecret>();
            proof.setAmount(r.amount());
            proof.setKeySetId(r.keysetId());
            proof.setSecret(RandomStringSecret.fromBytes(r.secret()));
            int byteLen = r.cHex() == null ? -1 : r.cHex().length() / 2;
            log.debug("melt_service proof_input_prepared amount={} keyset_id={} signature_hex_preview={} byte_length={}", r.amount(), r.keysetId(), this.redactSignatureHex(r.cHex()), byteLen);
            try {
                proof.setUnblindedSignature(MeltService.signatureFromHex(r.cHex()));
            }
            catch (RuntimeException e) {
                log.error("melt_service proof_input_signature_invalid amount={} keyset_id={} signature_hex_preview={} byte_length={} impact=swap_aborted", r.amount(), r.keysetId(), this.redactSignatureHex(r.cHex()), byteLen, e);
                throw e;
            }
            inputs.add(proof);
        }
        return inputs;
    }

    private SwapExecution performSwap(String mintUrl, String outKeysetId, long sum, long target, List<Proof<RandomStringSecret>> inputs) {
        long change = sum - target;
        ArrayList<Integer> outDenoms = new ArrayList<Integer>(MeltService.denomSplit((int)target));
        if (change > 0L) {
            outDenoms.addAll(MeltService.denomSplit((int)change));
        }
        ArrayList<BlindedMessage> blindedMessages = new ArrayList<BlindedMessage>();
        ArrayList<RandomStringSecret> outSecrets = new ArrayList<RandomStringSecret>();
        ArrayList<byte[]> outR = new ArrayList<byte[]>();
        Iterator iterator2 = outDenoms.iterator();
        while (iterator2.hasNext()) {
            int a = (Integer)iterator2.next();
            RandomStringSecret secret = RandomStringSecret.create();
            outSecrets.add(secret);
            byte[][] blind = this.crypto.blindMessage(secret.getData());
            byte[] blindedBytes = blind[0];
            byte[] r = blind[1];
            outR.add(r);
            BlindedMessage bm = BlindedMessage.builder().amount(a).keySetId(KeysetId.fromString(outKeysetId)).blindedMessage(PublicKey.fromBytes(blindedBytes, false)).build();
            blindedMessages.add(bm);
        }
        PostSwapRequest swapReq = new PostSwapRequest(inputs, blindedMessages);
        PostSwapResponse swapResp = this.mintApi.swap(mintUrl, swapReq);
        return new SwapExecution(swapResp, outSecrets, outR, outDenoms);
    }

    private List<NewProof> processSwapResults(SwapExecution exec, KeysetInfo keyset) {
        ArrayList<NewProof> newProofs = new ArrayList<NewProof>();
        for (int i2 = 0; i2 < exec.swapResp().getBlindSignatures().size(); ++i2) {
            BlindSignature bs = exec.swapResp().getBlindSignatures().get(i2);
            int a = bs.getAmount();
            byte[] blindedSig = bs.getBlindedSignature().getBytes();
            byte[] r = exec.outR().get(i2);
            byte[] pub = keyset.pubByAmount().get(a);
            if (pub == null) {
                throw new IllegalStateException("Missing mint pubkey for amount " + a);
            }
            byte[] unblinded = this.crypto.unblindSignature(blindedSig, r, pub);
            String cHex = MeltService.bytesToHex(unblinded);
            log.debug("melt_service swap_signature_unblinded amount={} signature_hex_preview={} byte_length={}", a, this.redactSignatureHex(cHex), unblinded == null ? -1 : unblinded.length);
            byte[] secretBytes = exec.outSecrets().get(i2).getData();
            try {
                secretBytes = this.encryptionService.encrypt(secretBytes);
            }
            catch (EncryptionException encryptionException) {
                // empty catch block
            }
            newProofs.add(new NewProof(a, cHex, secretBytes, keyset.keysetId()));
        }
        int expected = exec.outDenoms().stream().mapToInt(Integer::intValue).sum();
        int actual = newProofs.stream().mapToInt(NewProof::amount).sum();
        if (actual != expected) {
            throw new InvalidChangeException("Invalid change detected. Swap returned " + actual + " sats but expected " + expected + ". Suggestion: Retry the swap; if the issue persists, contact the mint operator and avoid spending affected proofs.");
        }
        return newProofs;
    }

    private void saveSwapResults(String mintUrl, String unit, Selection selection, List<NewProof> newProofs) {
        this.repository.persistProofs(mintUrl, unit, newProofs);
        this.repository.markProofsAsSpent(selection.rows());
    }

    private List<NewProof> selectProofsForMelt(List<NewProof> newProofs, long target) {
        ArrayList<NewProof> newProofsForMelt = new ArrayList<NewProof>();
        long sum = 0L;
        for (NewProof np : newProofs) {
            if (sum + (long)np.amount() > target) continue;
            newProofsForMelt.add(np);
            sum += (long)np.amount();
        }
        return newProofsForMelt;
    }

    private List<NewProof> selectionToProofs(Selection selection) {
        ArrayList<NewProof> proofs = new ArrayList<NewProof>();
        for (ProofRecord r : selection.rows()) {
            proofs.add(new NewProof(r.amount(), r.cHex(), r.secret(), r.keysetId()));
        }
        return proofs;
    }

    private String redactSignatureHex(String hex) {
        if (hex == null) {
            return "null";
        }
        int length = hex.length();
        int prefixLength = Math.min(8, length);
        String prefix = hex.substring(0, prefixLength);
        return prefix + "...(len=" + length + ")";
    }

    private void executeMelt(MeltRequestContext request, MintApi.MeltQuote quote, List<NewProof> newProofsForMelt) {
        PostMeltResponse mintResponse;
        ArrayList inputs = new ArrayList();
        for (NewProof np : newProofsForMelt) {
            Proof<RandomStringSecret> proof = new Proof<RandomStringSecret>();
            proof.setAmount(np.amount());
            proof.setKeySetId(np.keysetId());
            proof.setSecret(RandomStringSecret.fromBytes(np.secret()));
            int byteLen = np.cHex() == null ? -1 : np.cHex().length() / 2;
            log.debug("melt_service melt_input_prepared amount={} keyset_id={} signature_hex_preview={} byte_length={}", np.amount(), np.keysetId(), this.redactSignatureHex(np.cHex()), byteLen);
            try {
                proof.setUnblindedSignature(MeltService.signatureFromHex(np.cHex()));
            }
            catch (RuntimeException e) {
                log.error("melt_service melt_input_signature_invalid amount={} keyset_id={} signature_hex_preview={} byte_length={} impact=payment_aborted", np.amount(), np.keysetId(), this.redactSignatureHex(np.cHex()), byteLen, e);
                throw e;
            }
            inputs.add(proof);
        }
        PostMeltRequest meltReq = new PostMeltRequest(quote.quoteId(), inputs);
        try {
            mintResponse = this.mintApi.melt(request.mintUrl(), quote.quoteId(), request.unit(), meltReq);
        }
        catch (MintApiException e) {
            if (QuoteExpiryDetector.isQuoteExpired(e)) {
                throw new MeltQuoteExpiredException("Melt quote expired before payment", e);
            }
            throw e;
        }
        if (!mintResponse.isPaid()) {
            long delayMs = PollingConfig.meltIntervalMs();
            long timeoutMs = PollingConfig.meltTimeoutMs();
            long deadlineMs = System.currentTimeMillis() + timeoutMs;
            boolean paid = false;
            while (System.currentTimeMillis() < deadlineMs) {
                if (this.mintApi.meltQuotePaid(request.mintUrl(), request.unit(), quote.quoteId())) {
                    paid = true;
                    break;
                }
                try {
                    Thread.sleep(delayMs);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            if (!paid) {
                if (MeltService.useCheckBeforeSpend()) {
                    try {
                        PostCheckStateRequest mintRequest = new PostCheckStateRequest(this.newProofsToHashToCurve(newProofsForMelt));
                        PostCheckStateResponse chk = this.mintApi.check(request.mintUrl(), mintRequest);
                        this.reconcileSpentFromCheck(request.mintUrl(), request.unit(), newProofsForMelt, chk);
                    }
                    catch (RuntimeException e) {
                        log.warn("melt_service reconciliation_failed mint_url={} unit={} reason={} outcome=manual_review", request.mintUrl(), request.unit(), e.getMessage(), e);
                    }
                }
                throw new LightningPaymentException("Lightning payment not settled. Mint did not mark the invoice as paid within the timeout. Suggestion: Verify the invoice was paid, then retry or request a new melt quote.");
            }
        }
    }

    private Selection selectProofsAtLeast(String unit, String mintUrl, long target) {
        List<ProofRecord> rows = this.repository.listProofs(unit, mintUrl);
        ArrayList<ProofRecord> picked = new ArrayList<ProofRecord>();
        long sum = 0L;
        for (ProofRecord r : rows) {
            if (sum >= target) break;
            picked.add(r);
            sum += (long)r.amount();
        }
        return new Selection(picked, sum);
    }

    private List<HashToCurveSecret> rowsToHashToCurve(List<ProofRecord> rows) {
        ArrayList<HashToCurveSecret> list = new ArrayList<HashToCurveSecret>();
        for (ProofRecord r : rows) {
            list.add(new HashToCurveSecret(RandomStringSecret.fromBytes(r.secret())));
        }
        return list;
    }

    private List<HashToCurveSecret> newProofsToHashToCurve(List<NewProof> nps) {
        ArrayList<HashToCurveSecret> list = new ArrayList<HashToCurveSecret>();
        for (NewProof np : nps) {
            list.add(new HashToCurveSecret(RandomStringSecret.fromBytes(np.secret())));
        }
        return list;
    }

    private static List<Integer> denomSplit(int amount) {
        int denom;
        ArrayList<Integer> parts = new ArrayList<Integer>();
        int remaining = amount;
        for (denom = 1; denom <= remaining; denom *= 2) {
        }
        denom /= 2;
        while (remaining > 0) {
            if (remaining >= denom) {
                parts.add(denom);
                remaining -= denom;
                continue;
            }
            denom /= 2;
        }
        return parts;
    }

    private void reconcileSpentFromCheck(String mintUrl, String unit, List<NewProof> proofs, PostCheckStateResponse chk) {
        HashMap<String, NewProof> byHtc = new HashMap<String, NewProof>();
        for (NewProof np : proofs) {
            ECPoint pt = BDHKEUtils.hashToCurve(np.secret());
            String key = PublicKey.fromPoint(pt).toString();
            byHtc.put(key, np);
        }
        log.debug("melt_service reconciliation_keys_built mint_url={} unit={} key_count={}", mintUrl, unit, byHtc.size());
        List<PostCheckStateResponse.ResponseState> states = chk.getStates();
        if (states == null) {
            return;
        }
        ArrayList<NewProof> toMark = new ArrayList<NewProof>();
        for (PostCheckStateResponse.ResponseState st : states) {
            NewProof np;
            HashToCurveSecret k = st.getHashToCurveSecret();
            String s = st.getState();
            if (k == null || s == null || "UNSPENT".equalsIgnoreCase(s) || (np = (NewProof)byHtc.get(k.toString())) == null) continue;
            toMark.add(np);
        }
        log.debug("melt_service reconciliation_marking_spent mint_url={} unit={} proof_count={}", mintUrl, unit, toMark.size());
        if (!toMark.isEmpty()) {
            this.repository.markProofsSpent(mintUrl, unit, toMark);
        }
    }

    private static boolean useCheckBeforeSpend() {
        String envValue = System.getenv().getOrDefault("WALLET_CHECK_BEFORE_SPEND", "true");
        return Boolean.parseBoolean(envValue);
    }

    private static byte[] hexToBytes(String hexString) {
        int len = hexString.length();
        byte[] bytes = new byte[len / 2];
        for (int i2 = 0; i2 < len; i2 += 2) {
            bytes[i2 / 2] = (byte)((Character.digit(hexString.charAt(i2), 16) << 4) + Character.digit(hexString.charAt(i2 + 1), 16));
        }
        return bytes;
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexArray = "0123456789abcdef".toCharArray();
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    private static Signature signatureFromHex(String hex) {
        if (hex == null) {
            throw new IllegalArgumentException("signature hex is null");
        }
        if (HexCaseUtils.hasMixedCaseHexLetters(hex)) {
            throw new IllegalArgumentException("signature hex mixed-case not allowed");
        }
        String h = hex.toLowerCase();
        if (h.length() == 66 && (h.startsWith("02") || h.startsWith("03"))) {
            return Signature.fromString(h);
        }
        if (h.length() == 128) {
            return Signature.fromBytes(MeltService.hexToBytes(h));
        }
        throw new IllegalArgumentException("signature hex length invalid");
    }

    private static String redactSignature(String hex) {
        if (hex == null || hex.isBlank()) {
            return "(redacted)";
        }
        String normalized = hex.length() <= 12 ? hex : hex.substring(0, 12) + "...";
        return normalized;
    }

    private record QuoteSelection(MintApi.MeltQuote quote, Selection selection, long target) {
    }

    private record KeysetInfo(String keysetId, Map<Integer, byte[]> pubByAmount) {
    }

    private record SwapExecution(PostSwapResponse swapResp, List<RandomStringSecret> outSecrets, List<byte[]> outR, List<Integer> outDenoms) {
    }
}

