/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.mint;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.common.ActiveKeySet;
import xyz.tcheeric.cashu.common.BlindSignature;
import xyz.tcheeric.cashu.common.BlindedMessage;
import xyz.tcheeric.cashu.common.KeySet;
import xyz.tcheeric.cashu.common.KeysetId;
import xyz.tcheeric.cashu.common.PublicKey;
import xyz.tcheeric.cashu.common.RandomStringSecret;
import xyz.tcheeric.cashu.common.util.SplittingService;
import xyz.tcheeric.cashu.entities.rest.GetActiveKeySetsResponse;
import xyz.tcheeric.cashu.entities.rest.GetKeySetsResponse;
import xyz.tcheeric.cashu.entities.rest.PostMintRequest;
import xyz.tcheeric.cashu.entities.rest.PostMintResponse;
import xyz.tcheeric.wallet.core.PollingConfig;
import xyz.tcheeric.wallet.core.api.MintApi;
import xyz.tcheeric.wallet.core.api.MintApiException;
import xyz.tcheeric.wallet.core.api.MintInvoiceNotPaidException;
import xyz.tcheeric.wallet.core.crypto.CryptoAdapter;
import xyz.tcheeric.wallet.core.db.ProofRepository;
import xyz.tcheeric.wallet.core.proof.NewProof;
import xyz.tcheeric.wallet.core.security.EncryptionException;
import xyz.tcheeric.wallet.core.security.EncryptionService;

public class MintService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MintService.class);
    private final MintApi mintApi;
    private final CryptoAdapter crypto;
    private final ProofRepository repository;
    private final EncryptionService encryptionService;
    private final SplittingService splittingService = new SplittingService();

    public MintService(MintApi mintApi, CryptoAdapter crypto, ProofRepository repository, EncryptionService encryptionService) {
        this.mintApi = mintApi;
        this.crypto = crypto;
        this.repository = repository;
        this.encryptionService = encryptionService;
    }

    public void mint(long amount, String unit, String mintUrl) {
        MintApi.MintQuote quote = this.mintApi.quoteMint(mintUrl, unit, amount);
        long deadlineMs = System.currentTimeMillis() + PollingConfig.mintTimeoutMs();
        this.waitForQuotePaid(mintUrl, unit, quote.quoteId(), deadlineMs);
        this.executeMintWithPaymentSync(amount, unit, mintUrl, quote.quoteId(), deadlineMs);
    }

    public void mintWithQuote(String quoteId, long amount, String unit, String mintUrl) {
        if (quoteId == null || quoteId.isBlank()) {
            throw new IllegalArgumentException("quoteId must not be null or blank");
        }
        long deadlineMs = System.currentTimeMillis() + PollingConfig.mintTimeoutMs();
        this.waitForQuotePaid(mintUrl, unit, quoteId, deadlineMs);
        this.executeMintWithPaymentSync(amount, unit, mintUrl, quoteId, deadlineMs);
    }

    private void waitForQuotePaid(String mintUrl, String unit, String quoteId, long deadlineMs) {
        long delayMs = PollingConfig.mintIntervalMs();
        while (System.currentTimeMillis() < deadlineMs) {
            if (this.mintApi.mintQuotePaid(mintUrl, unit, quoteId)) {
                return;
            }
            try {
                Thread.sleep(delayMs);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        throw new MintApiException("Minting failed due to unpaid quote. Quote remained unpaid after polling timeout. Suggestion: Complete invoice payment and retry minting or request a new quote.", mintUrl, Map.of("quoteId", quoteId), null);
    }

    private void executeMintWithPaymentSync(long amount, String unit, String mintUrl, String quoteId, long deadlineMs) {
        while (true) {
            try {
                this.executeMint(amount, unit, mintUrl, quoteId);
                return;
            }
            catch (MintInvoiceNotPaidException invoiceNotPaid) {
                long remaining = deadlineMs - System.currentTimeMillis();
                if (remaining <= 0L) {
                    String what = String.format("Mint rejected mint request because invoice never reached PAID state for quoteId=%s", quoteId);
                    String why = "Mint refused to mint despite repeated confirmations";
                    String suggestion = "Request a new quote after the Lightning payment settles, then retry";
                    throw new MintApiException(String.format("%s. %s. Suggestion: %s", what, why, suggestion), mintUrl, Map.of("quoteId", quoteId, "unit", unit), invoiceNotPaid);
                }
                log.warn("mint_service quote_not_paid_retry quoteId={} remaining_ms={} message={} suggestion=waiting_for_invoice", quoteId, remaining, invoiceNotPaid.getMessage());
                this.waitForQuotePaid(mintUrl, unit, quoteId, deadlineMs);
                continue;
            }
            break;
        }
    }

    protected void executeMint(long amount, String unit, String mintUrl, String quoteId) {
        KeysetInfo keyset = this.retrieveKeyset(unit, mintUrl);
        MintRequestData requestData = this.assembleMintRequest(amount, keyset, quoteId);
        PostMintResponse mintResponse = this.mintApi.mint(mintUrl, quoteId, unit, requestData.request());
        List<NewProof> newProofs = this.unblindSignatures(mintResponse, requestData, keyset);
        this.repository.persistProofs(mintUrl, unit, newProofs);
    }

    private KeysetInfo retrieveKeyset(String unit, String mintUrl) {
        GetActiveKeySetsResponse activeKeySetsResponse = this.mintApi.activeKeysets(mintUrl);
        String keysetId = activeKeySetsResponse.getActiveKeySets().stream().filter(k -> unit.equalsIgnoreCase(k.getUnit()) && k.isActive()).map(ActiveKeySet::getId).findFirst().orElseThrow(() -> new IllegalStateException("No active keyset for unit " + unit));
        GetKeySetsResponse keysetResp = this.mintApi.keyset(mintUrl, keysetId);
        KeySet keyset = keysetResp.getKeySets().stream().filter(k -> keysetId.equals(k.getId())).findFirst().orElseThrow(() -> new IllegalStateException("Keyset not found: " + keysetId));
        return new KeysetInfo(keysetId, keyset);
    }

    private MintRequestData assembleMintRequest(long amount, KeysetInfo keyset, String quoteId) {
        List<Integer> parts = this.splittingService.split(amount, keyset.pubByAmount().keySet());
        PostMintRequest<RandomStringSecret> mintRequest = new PostMintRequest<RandomStringSecret>();
        mintRequest.setQuoteId(quoteId);
        ArrayList<byte[]> blindingFactors = new ArrayList<byte[]>();
        ArrayList<RandomStringSecret> secrets = new ArrayList<RandomStringSecret>();
        ArrayList<BlindedMessage> blindedMessages = new ArrayList<BlindedMessage>();
        for (int a : parts) {
            RandomStringSecret secret = RandomStringSecret.create();
            secrets.add(secret);
            byte[][] blind = this.crypto.blindMessage(secret.getData());
            byte[] blindedBytes = blind[0];
            byte[] r = blind[1];
            blindingFactors.add(r);
            BlindedMessage bm = BlindedMessage.builder().amount(a).keySetId(KeysetId.fromString(keyset.id())).blindedMessage(PublicKey.fromBytes(blindedBytes, false)).build();
            blindedMessages.add(bm);
        }
        mintRequest.setBlindedMessages(blindedMessages);
        mintRequest.setSecrets(new ArrayList(secrets));
        mintRequest.setBlindingFactors(new ArrayList<byte[]>(blindingFactors));
        return new MintRequestData(mintRequest, blindingFactors, secrets);
    }

    private List<NewProof> unblindSignatures(PostMintResponse mintResponse, MintRequestData data, KeysetInfo keyset) {
        HashMap<Integer, byte[]> pubByAmount = new HashMap<Integer, byte[]>();
        pubByAmount.putAll(keyset.pubByAmount());
        ArrayList<NewProof> newProofs = new ArrayList<NewProof>();
        for (int i2 = 0; i2 < mintResponse.getBlindSignatures().size(); ++i2) {
            BlindSignature blindSignature = mintResponse.getBlindSignatures().get(i2);
            int amount = blindSignature.getAmount();
            try {
                String cHex = blindSignature.getBlindedSignature() == null ? "null" : blindSignature.getBlindedSignature().toString();
                log.debug("mint_service blinded_signature_received amount={} c_hex={}", (Object)amount, (Object)cHex);
            }
            catch (Throwable cHex) {
                // empty catch block
            }
            byte[] blindedSig = blindSignature.getBlindedSignature().getBytes();
            byte[] blindingFactor = data.blindingFactors().get(i2);
            byte[] mintPublicKey = (byte[])pubByAmount.get(amount);
            if (mintPublicKey == null) {
                throw new IllegalStateException("Missing mint pubkey for amount " + amount);
            }
            byte[] unblinded = this.crypto.unblindSignature(blindedSig, blindingFactor, mintPublicKey);
            String unblindedSignatureHex = MintService.bytesToHex(unblinded);
            log.debug("mint_service signature_unblinded amount={} signature={} byte_length={}", amount, unblindedSignatureHex, unblinded == null ? -1 : unblinded.length);
            byte[] secretBytes = data.secrets().get(i2).getData();
            try {
                secretBytes = this.encryptionService.encrypt(secretBytes);
            }
            catch (EncryptionException encryptionException) {
                // empty catch block
            }
            newProofs.add(new NewProof(amount, unblindedSignatureHex, secretBytes, keyset.id()));
        }
        return newProofs;
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexArray = "0123456789abcdef".toCharArray();
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    private record KeysetInfo(String id, KeySet keyset, Map<Integer, byte[]> pubByAmount) {
        KeysetInfo(String id, KeySet keyset) {
            this(id, keyset, KeysetInfo.buildPubByAmount(keyset));
        }

        private static Map<Integer, byte[]> buildPubByAmount(KeySet keyset) {
            HashMap<Integer, byte[]> map = new HashMap<Integer, byte[]>();
            if (keyset == null || keyset.getKeys() == null) {
                return map;
            }
            keyset.getKeys().getValues().forEach((amount, key) -> map.put(amount.intValue(), key.toBytes()));
            return map;
        }
    }

    private record MintRequestData(PostMintRequest<RandomStringSecret> request, List<byte[]> blindingFactors, List<RandomStringSecret> secrets) {
    }
}

