/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.adapter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import lombok.Generated;
import nostr.base.ElementAttribute;
import nostr.base.PublicKey;
import nostr.base.Signature;
import nostr.client.springwebsocket.SpringWebSocketClient;
import nostr.event.BaseTag;
import nostr.event.filter.Filters;
import nostr.event.filter.SinceFilter;
import nostr.event.impl.GenericEvent;
import nostr.event.message.CloseMessage;
import nostr.event.message.EventMessage;
import nostr.event.message.ReqMessage;
import nostr.event.tag.GenericTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.messaging.contracts.MessageClient;
import xyz.tcheeric.messaging.messages.SignEventRequest;
import xyz.tcheeric.messaging.messages.SignEventResponse;
import xyz.tcheeric.wallet.core.nostr.NostrEvent;
import xyz.tcheeric.wallet.core.nostr.NostrRelayClient;
import xyz.tcheeric.wallet.core.nostr.NostrSubscription;
import xyz.tcheeric.wallet.core.nostr.RelayUnavailableException;
import xyz.tcheeric.wallet.core.nostr.adapter.NostrEventAdapter;
import xyz.tcheeric.wallet.core.nostr.adapter.SpringContextFactory;
import xyz.tcheeric.wallet.core.nostr.adapter.SubscriptionAdapter;
import xyz.tcheeric.wallet.core.nostr.dm.Nip42AuthProvider;
import xyz.tcheeric.wallet.core.security.IdentityKey;
import xyz.tcheeric.wallet.core.security.WalletSigningKey;

public class NostrJavaRelayClient
implements NostrRelayClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NostrJavaRelayClient.class);
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();
    private final String relayUrl;
    private final SpringContextFactory.ManagedSpringContext springContext;
    private final SpringWebSocketClient webSocketClient;
    private final CircuitBreaker circuitBreaker;
    private final ConcurrentMap<String, SubscriptionHandle> activeSubscriptions;
    private final ConcurrentMap<String, CountDownLatch> subscriptionReadyLatches = new ConcurrentHashMap<String, CountDownLatch>();
    private final MessageClient messageClient;
    private volatile boolean authEnabled = false;
    private volatile boolean connected = false;
    private volatile String authToken;
    @Deprecated
    private volatile IdentityKey identityKey;
    @Deprecated
    private volatile WalletSigningKey walletSigningKey;
    private volatile boolean closed = false;
    private volatile Nip42AuthProvider authProvider;

    public NostrJavaRelayClient(String relayUrl, MessageClient messageClient) {
        this.relayUrl = Objects.requireNonNull(relayUrl, "relayUrl cannot be null");
        if (relayUrl.isBlank()) {
            throw new IllegalArgumentException("relayUrl cannot be blank");
        }
        this.messageClient = messageClient;
        log.debug("Creating NostrJavaRelayClient for relay: " + relayUrl);
        this.springContext = SpringContextFactory.createContextForRelay(relayUrl);
        this.webSocketClient = this.springContext.getClient();
        this.circuitBreaker = this.createCircuitBreaker(relayUrl);
        this.activeSubscriptions = new ConcurrentHashMap<String, SubscriptionHandle>();
        log.debug("NostrJavaRelayClient created for relay: " + relayUrl);
    }

    @Deprecated
    public NostrJavaRelayClient(String relayUrl) {
        this(relayUrl, (MessageClient)null);
    }

    @Deprecated
    public NostrJavaRelayClient(String relayUrl, Nip42AuthProvider authProvider) {
        this(relayUrl, (MessageClient)null);
        this.authProvider = authProvider;
    }

    private CircuitBreaker createCircuitBreaker(String relayUrl) {
        CircuitBreakerConfig config = NostrJavaRelayClient.buildCircuitBreakerConfigFromSystem();
        CircuitBreakerRegistry registry = CircuitBreakerRegistry.of(config);
        return registry.circuitBreaker("relay-" + relayUrl);
    }

    private static CircuitBreakerConfig buildCircuitBreakerConfigFromSystem() {
        int failureRate = NostrJavaRelayClient.getIntProp("wallet.relay.circuitBreaker.failureRateThreshold", 50);
        String windowTypeStr = NostrJavaRelayClient.getProp("wallet.relay.circuitBreaker.windowType", "COUNT");
        int windowSize = NostrJavaRelayClient.getIntProp("wallet.relay.circuitBreaker.windowSize", 10);
        int minCalls = NostrJavaRelayClient.getIntProp("wallet.relay.circuitBreaker.minimumCalls", 5);
        long openWaitMs = NostrJavaRelayClient.getLongProp("wallet.relay.circuitBreaker.openWaitMs", 60000L);
        int halfOpenPermits = NostrJavaRelayClient.getIntProp("wallet.relay.circuitBreaker.permittedHalfOpen", 3);
        CircuitBreakerConfig.SlidingWindowType windowType = "TIME".equalsIgnoreCase(windowTypeStr) ? CircuitBreakerConfig.SlidingWindowType.TIME_BASED : CircuitBreakerConfig.SlidingWindowType.COUNT_BASED;
        return CircuitBreakerConfig.custom().failureRateThreshold(failureRate).slowCallRateThreshold(50.0f).slowCallDurationThreshold(Duration.ofSeconds(5L)).slidingWindowType(windowType).slidingWindowSize(windowSize).minimumNumberOfCalls(minCalls).waitDurationInOpenState(Duration.ofMillis(openWaitMs)).permittedNumberOfCallsInHalfOpenState(halfOpenPermits).automaticTransitionFromOpenToHalfOpenEnabled(true).build();
    }

    private static String getProp(String key, String def) {
        String v = System.getProperty(key);
        if (v == null || v.isBlank()) {
            v = System.getenv(key.replace('.', '_').toUpperCase());
        }
        return v == null || v.isBlank() ? def : v;
    }

    private static int getIntProp(String key, int def) {
        try {
            return Integer.parseInt(NostrJavaRelayClient.getProp(key, Integer.toString(def)));
        }
        catch (Exception ignored) {
            return def;
        }
    }

    private static long getLongProp(String key, long def) {
        try {
            return Long.parseLong(NostrJavaRelayClient.getProp(key, Long.toString(def)));
        }
        catch (Exception ignored) {
            return def;
        }
    }

    @Override
    public String url() {
        return this.relayUrl;
    }

    @Override
    public void connect() {
        this.checkNotClosed();
        if (this.connected) {
            log.debug("Already connected to relay: " + this.relayUrl);
            return;
        }
        log.debug("Connecting to relay: " + this.relayUrl);
        this.circuitBreaker.executeRunnable(() -> {
            try {
                if (this.springContext.isClosed()) {
                    throw new RelayConnectionException("Spring context is closed for relay: " + this.relayUrl, null);
                }
                this.connected = true;
                log.debug("Connected to relay: " + this.relayUrl);
            }
            catch (Exception e) {
                this.connected = false;
                log.warn("Failed to connect to relay: " + this.relayUrl + " - " + e.getMessage());
                throw new RelayConnectionException("Failed to connect to relay: " + this.relayUrl, e);
            }
        });
    }

    public void disconnect() {
        this.checkNotClosed();
        if (!this.connected) {
            log.debug("Already disconnected from relay: " + this.relayUrl);
            return;
        }
        log.debug("Disconnecting from relay: " + this.relayUrl);
        for (SubscriptionHandle handle2 : this.activeSubscriptions.values()) {
            try {
                handle2.close();
            }
            catch (Exception e) {
                log.warn("Error closing subscription during disconnect: " + handle2.name + " - " + e.getMessage());
            }
        }
        this.activeSubscriptions.clear();
        this.connected = false;
        log.debug("Disconnected from relay: " + this.relayUrl);
    }

    public boolean isConnected() {
        return this.connected && !this.closed;
    }

    public void enableAuth(String authToken) {
        this.checkNotClosed();
        Objects.requireNonNull(authToken, "authToken cannot be null");
        if (authToken.isBlank()) {
            throw new IllegalArgumentException("authToken cannot be blank");
        }
        this.authToken = authToken;
        this.authEnabled = true;
        log.debug("Authentication enabled for relay: " + this.relayUrl + " (identity-plugin)");
    }

    @Override
    @Deprecated
    public void enableAuth(IdentityKey identityKey, WalletSigningKey walletSigningKey) {
        this.checkNotClosed();
        Objects.requireNonNull(identityKey, "identityKey cannot be null");
        Objects.requireNonNull(walletSigningKey, "walletSigningKey cannot be null");
        this.identityKey = identityKey;
        this.walletSigningKey = walletSigningKey;
        this.authEnabled = true;
        log.debug("Authentication enabled for relay: " + this.relayUrl + " (legacy)");
    }

    @Override
    public void publish(NostrEvent event) {
        this.checkNotClosed();
        this.checkConnected();
        Objects.requireNonNull(event, "event cannot be null");
        log.debug("Publishing event to relay: " + this.relayUrl + " - event ID: " + event.id());
        this.circuitBreaker.executeRunnable(() -> {
            try {
                EventMessage eventMessage;
                List<String> responses;
                NostrEvent signedEvent = this.signEventIfNeeded(event);
                GenericEvent nostrEvent = NostrEventAdapter.toNostrJavaEvent(signedEvent);
                if (nostrEvent.getId() == null || nostrEvent.getSignature() == null) {
                    nostrEvent.update();
                }
                if ((responses = this.webSocketClient.send(eventMessage = new EventMessage(nostrEvent))) != null && !responses.isEmpty()) {
                    for (String response : responses) {
                        this.handlePublishResponse(signedEvent.id(), response);
                    }
                }
                log.debug("Published event to relay: " + this.relayUrl + " - event ID: " + signedEvent.id() + " - responses: " + (responses != null ? responses.size() : 0));
            }
            catch (IOException e) {
                log.warn("Failed to publish event to relay: " + this.relayUrl + " - " + e.getMessage());
                throw new RelayPublishException("Failed to publish event to relay: " + this.relayUrl, e);
            }
            catch (Exception e) {
                log.warn("Unexpected error publishing event to relay: " + this.relayUrl + " - " + e.getMessage());
                throw new RelayPublishException("Unexpected error publishing event to relay: " + this.relayUrl, e);
            }
        });
    }

    private NostrEvent signEventIfNeeded(NostrEvent event) {
        if (event.sig() != null && !event.sig().isBlank()) {
            log.debug("Event already signed, skipping signing: " + event.id());
            return event;
        }
        if (this.messageClient == null || this.authToken == null || this.authToken.isBlank()) {
            log.debug("MessageClient or authToken not available, returning unsigned event");
            return event;
        }
        try {
            log.debug("Signing event via identity-plugin: kind={} content_length={}", (Object)event.kind(), (Object)event.content().length());
            SignEventRequest request = new SignEventRequest(UUID.randomUUID().toString(), this.authToken, event.kind(), event.content(), event.tags(), event.createdAt().getEpochSecond());
            SignEventResponse response = this.messageClient.sendSync(request, SignEventResponse.class);
            if (!response.success()) {
                log.warn("Failed to sign event via identity-plugin: {}", (Object)response.errorMessage());
                return event;
            }
            NostrEvent signedEvent = new NostrEvent(response.eventId(), response.pubkey(), event.kind(), event.content(), event.createdAt(), event.tags(), response.signature());
            log.debug("Event signed successfully via identity-plugin: id={} pubkey={}", (Object)response.eventId(), (Object)response.pubkey());
            return signedEvent;
        }
        catch (Exception e) {
            log.warn("Error signing event via identity-plugin: " + e.getMessage(), e);
            return event;
        }
    }

    @Override
    public AutoCloseable subscribe(NostrSubscription subscription, Consumer<NostrEvent> consumer) {
        this.checkNotClosed();
        this.checkConnected();
        Objects.requireNonNull(subscription, "subscription cannot be null");
        Objects.requireNonNull(consumer, "consumer cannot be null");
        log.debug("Subscribing to relay: " + this.relayUrl + " - subscription: " + subscription.name());
        return this.circuitBreaker.executeSupplier(() -> {
            try {
                String subscriptionId = "sub-" + UUID.randomUUID().toString().substring(0, 8);
                List<Filters> serverFilters = SubscriptionAdapter.toNostrJavaFilters(subscription);
                CountDownLatch readyLatch = new CountDownLatch(1);
                this.subscriptionReadyLatches.put(subscriptionId, readyLatch);
                if (serverFilters == null || serverFilters.isEmpty()) {
                    Filters catchAll = new Filters(new SinceFilter(0L));
                    int limit = NostrJavaRelayClient.getIntProp("wallet.relay.subscription.catchAllLimit", 0);
                    if (limit > 0) {
                        catchAll.setLimit(limit);
                    }
                    serverFilters = List.of(catchAll);
                }
                ReqMessage reqMessage = new ReqMessage(subscriptionId, serverFilters);
                AutoCloseable webSocketSubscription = this.webSocketClient.subscribe(reqMessage, jsonMessage -> {
                    try {
                        this.handleSubscriptionMessage(subscriptionId, subscription, consumer, (String)jsonMessage);
                    }
                    catch (Exception e) {
                        log.warn("Error processing message from relay: " + this.relayUrl + " - " + e.getMessage());
                    }
                }, error -> log.warn("Subscription error for relay: " + this.relayUrl + " - " + error.getMessage()), () -> log.debug("Subscription closed for relay: " + this.relayUrl + " - subscription: " + subscription.name()));
                SubscriptionHandle handle2 = new SubscriptionHandle(subscriptionId, webSocketSubscription, subscription.name());
                this.activeSubscriptions.put(subscriptionId, handle2);
                long fallbackMs = NostrJavaRelayClient.getLongProp("wallet.relay.subscription.readyFallbackMs", 500L);
                if (fallbackMs > 0L) {
                    CompletableFuture.runAsync(() -> {
                        CountDownLatch latch = (CountDownLatch)this.subscriptionReadyLatches.get(subscriptionId);
                        if (latch != null && latch.getCount() > 0L) {
                            log.debug("EOSE fallback triggered after {} ms for {}", (Object)fallbackMs, (Object)subscription.name());
                            this.countDownSubscriptionReady(subscriptionId);
                        }
                    }, CompletableFuture.delayedExecutor(fallbackMs, TimeUnit.MILLISECONDS));
                }
                log.debug("Subscribed to relay: " + this.relayUrl + " - subscription: " + subscription.name() + " - ID: " + subscriptionId);
                long waitMs = NostrJavaRelayClient.getLongProp("wallet.relay.subscription.readyWaitMs", 2000L);
                try {
                    if (!readyLatch.await(waitMs, TimeUnit.MILLISECONDS)) {
                        log.debug("Subscription ready wait timed out after {} ms for {}", (Object)waitMs, (Object)subscription.name());
                    }
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    if (readyLatch.getCount() == 0L) {
                        this.subscriptionReadyLatches.remove(subscriptionId, readyLatch);
                    }
                }
                return handle2;
            }
            catch (IOException e) {
                log.warn("Failed to subscribe to relay: " + this.relayUrl + " - " + e.getMessage());
                throw new RelaySubscribeException("Failed to subscribe to relay: " + this.relayUrl, e);
            }
            catch (Exception e) {
                log.warn("Unexpected error subscribing to relay: " + this.relayUrl + " - " + e.getMessage());
                throw new RelaySubscribeException("Unexpected error subscribing to relay: " + this.relayUrl, e);
            }
        });
    }

    private void handleSubscriptionMessage(String subscriptionId, NostrSubscription subscription, Consumer<NostrEvent> consumer, String jsonMessage) {
        if (jsonMessage != null && jsonMessage.startsWith("[\"AUTH\"")) {
            this.handleAuthChallenge(jsonMessage);
            return;
        }
        if (jsonMessage.contains("\"EVENT\"")) {
            GenericEvent genericEvent = this.parseEventFromJson(jsonMessage);
            if (genericEvent != null) {
                NostrEvent walletEvent = NostrEventAdapter.toWalletEvent(genericEvent);
                this.countDownSubscriptionReady(subscriptionId);
                if (subscription.filter().test(walletEvent)) {
                    consumer.accept(walletEvent);
                }
            }
        } else if (jsonMessage.contains("\"EOSE\"")) {
            log.debug("End of stored events for subscription: " + subscription.name() + " - relay: " + this.relayUrl);
            this.countDownSubscriptionReady(subscriptionId);
        } else if (jsonMessage.contains("\"NOTICE\"")) {
            String notice = this.extractNoticeMessage(jsonMessage);
            log.debug("Notice from relay " + this.relayUrl + ": " + notice);
        }
    }

    private void countDownSubscriptionReady(String subscriptionId) {
        try {
            CountDownLatch latch = (CountDownLatch)this.subscriptionReadyLatches.get(subscriptionId);
            if (latch != null) {
                latch.countDown();
                if (latch.getCount() == 0L) {
                    this.subscriptionReadyLatches.remove(subscriptionId, latch);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void handleAuthChallenge(String jsonMessage) {
        if (!this.authEnabled) {
            log.debug("AUTH challenge received but auth not enabled; ignoring for relay: " + this.relayUrl);
            return;
        }
        try {
            GenericEvent authEvent;
            JsonNode root = JSON_MAPPER.readTree(jsonMessage);
            if (!root.isArray() || root.size() < 2) {
                log.warn("Invalid AUTH message format: " + jsonMessage);
                return;
            }
            String challenge = root.get(1).asText();
            log.debug("Processing NIP-42 AUTH challenge for relay: " + this.relayUrl);
            List<List<String>> tags = List.of(List.of("challenge", challenge), List.of("relay", this.relayUrl));
            if (this.messageClient != null && this.authToken != null && !this.authToken.isBlank()) {
                log.debug("Signing AUTH event via identity-plugin");
                authEvent = this.buildAuthEventViaIdentityPlugin(challenge, tags);
            } else if (this.authProvider != null && this.identityKey != null && this.walletSigningKey != null) {
                log.debug("Signing AUTH event via legacy authProvider");
                authEvent = this.authProvider.buildAuthEvent(this.relayUrl, challenge, this.identityKey, this.walletSigningKey);
            } else {
                log.debug("Creating unsigned AUTH event (no signing method available)");
                authEvent = new GenericEvent();
                authEvent.setKind(22242);
                authEvent.setContent("");
                ArrayList<BaseTag> nostrTags = new ArrayList<BaseTag>();
                ArrayList<ElementAttribute> chalAttrs = new ArrayList<ElementAttribute>();
                chalAttrs.add(new ElementAttribute(null, "challenge"));
                chalAttrs.add(new ElementAttribute(null, challenge));
                nostrTags.add(new GenericTag("challenge", chalAttrs));
                ArrayList<ElementAttribute> relayAttrs = new ArrayList<ElementAttribute>();
                relayAttrs.add(new ElementAttribute(null, "relay"));
                relayAttrs.add(new ElementAttribute(null, this.relayUrl));
                nostrTags.add(new GenericTag("relay", relayAttrs));
                authEvent.setTags(nostrTags);
            }
            try {
                this.webSocketClient.send(new EventMessage(authEvent));
                log.debug("Sent AUTH response event to relay: " + this.relayUrl);
            }
            catch (Exception e) {
                log.warn("Failed sending AUTH response to relay: " + this.relayUrl + " - " + e.getMessage());
            }
        }
        catch (Exception e) {
            log.warn("Failed to process AUTH challenge from relay: " + this.relayUrl + " - " + e.getMessage());
        }
    }

    private GenericEvent buildAuthEventViaIdentityPlugin(String challenge, List<List<String>> tags) {
        try {
            SignEventRequest request = new SignEventRequest(UUID.randomUUID().toString(), this.authToken, 22242, "", tags, Instant.now().getEpochSecond());
            SignEventResponse response = this.messageClient.sendSync(request, SignEventResponse.class);
            if (!response.success()) {
                log.warn("Failed to sign AUTH event via identity-plugin: {}", (Object)response.errorMessage());
                throw new RuntimeException("Failed to sign AUTH event: " + response.errorMessage());
            }
            GenericEvent authEvent = new GenericEvent();
            authEvent.setId(response.eventId());
            authEvent.setPubKey(new PublicKey(response.pubkey()));
            authEvent.setKind(22242);
            authEvent.setContent("");
            authEvent.setCreatedAt(request.createdAt());
            authEvent.setSignature(Signature.fromString(response.signature()));
            ArrayList<BaseTag> nostrTags = new ArrayList<BaseTag>();
            for (List<String> tag : tags) {
                ArrayList<ElementAttribute> attrs = new ArrayList<ElementAttribute>();
                for (String element : tag) {
                    attrs.add(new ElementAttribute(null, element));
                }
                nostrTags.add(new GenericTag(tag.get(0), attrs));
            }
            authEvent.setTags(nostrTags);
            log.debug("AUTH event signed via identity-plugin: id={} pubkey={}", (Object)response.eventId(), (Object)response.pubkey());
            return authEvent;
        }
        catch (Exception e) {
            log.warn("Error signing AUTH event via identity-plugin: " + e.getMessage(), e);
            throw new RuntimeException("Failed to build AUTH event via identity-plugin", e);
        }
    }

    private String extractNoticeMessage(String jsonMessage) {
        try {
            JsonNode root = JSON_MAPPER.readTree(jsonMessage);
            if (root.isArray() && root.size() >= 2) {
                return root.get(1).asText("");
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    private void handlePublishResponse(String eventId, String response) {
        try {
            if (response.contains("\"OK\"")) {
                if (response.contains("true")) {
                    log.debug("Event accepted by relay: " + this.relayUrl + " - event ID: " + eventId);
                } else if (response.contains("false")) {
                    String errorMessage = this.extractErrorMessage(response);
                    log.warn("Event rejected by relay: " + this.relayUrl + " - event ID: " + eventId + " - reason: " + errorMessage);
                }
            } else {
                log.debug("Received response from relay: " + this.relayUrl + " - " + response);
            }
        }
        catch (Exception e) {
            log.warn("Error parsing publish response: " + e.getMessage());
        }
    }

    private String extractErrorMessage(String response) {
        try {
            int secondLastQuote;
            int lastQuote = response.lastIndexOf(34);
            if (lastQuote > 0 && (secondLastQuote = response.lastIndexOf(34, lastQuote - 1)) > 0) {
                return response.substring(secondLastQuote + 1, lastQuote);
            }
            return "unknown";
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    private GenericEvent parseEventFromJson(String jsonMessage) {
        try {
            String sigHex;
            JsonNode root = JSON_MAPPER.readTree(jsonMessage);
            if (!root.isArray() || root.size() < 3) {
                log.warn("Invalid EVENT message format: " + jsonMessage);
                return null;
            }
            if (!"EVENT".equals(root.get(0).asText())) {
                return null;
            }
            JsonNode eventNode = root.get(2);
            GenericEvent event = new GenericEvent();
            if (eventNode.has("id")) {
                event.setId(eventNode.get("id").asText());
            }
            if (eventNode.has("pubkey")) {
                event.setPubKey(new PublicKey(eventNode.get("pubkey").asText()));
            }
            if (eventNode.has("kind")) {
                event.setKind(eventNode.get("kind").asInt());
            }
            if (eventNode.has("content")) {
                event.setContent(eventNode.get("content").asText());
            }
            if (eventNode.has("created_at")) {
                event.setCreatedAt(eventNode.get("created_at").asLong());
            }
            if (eventNode.has("sig") && (sigHex = eventNode.get("sig").asText()) != null && !sigHex.isEmpty()) {
                event.setSignature(Signature.fromString(sigHex));
            }
            if (eventNode.has("tags")) {
                JsonNode tagsNode = eventNode.get("tags");
                ArrayList<BaseTag> tags = new ArrayList<BaseTag>();
                for (JsonNode tagArray : tagsNode) {
                    if (!tagArray.isArray() || tagArray.size() <= 0) continue;
                    ArrayList<ElementAttribute> attributes = new ArrayList<ElementAttribute>();
                    for (JsonNode element : tagArray) {
                        attributes.add(new ElementAttribute(null, element.asText()));
                    }
                    String code = tagArray.get(0).asText();
                    tags.add(new GenericTag(code, attributes));
                }
                event.setTags(tags);
            }
            return event;
        }
        catch (Exception e) {
            log.warn("Failed to parse event JSON: " + e.getMessage() + " - JSON: " + jsonMessage);
            return null;
        }
    }

    @Override
    public boolean isAuthEnabled() {
        return this.authEnabled;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        log.debug("Closing NostrJavaRelayClient for relay: " + this.relayUrl);
        if (this.connected) {
            try {
                this.disconnect();
            }
            catch (Exception e) {
                log.warn("Error during disconnect while closing: " + e.getMessage());
            }
        }
        try {
            this.springContext.close();
        }
        catch (Exception e) {
            log.warn("Error closing Spring context for relay: " + this.relayUrl + " - " + e.getMessage());
        }
        this.closed = true;
        this.connected = false;
        log.debug("Closed NostrJavaRelayClient for relay: " + this.relayUrl);
    }

    public CircuitBreaker getCircuitBreaker() {
        return this.circuitBreaker;
    }

    public SpringContextFactory.ManagedSpringContext getSpringContext() {
        return this.springContext;
    }

    static String extractRelayUrlFromMessage(String message) {
        if (message != null && message.contains("relay: ")) {
            int start = message.indexOf("relay: ") + 7;
            int end = message.indexOf(" ", start);
            if (end > start) {
                return message.substring(start, end);
            }
            if (start < message.length()) {
                return message.substring(start).trim();
            }
        }
        return "unknown";
    }

    private void checkNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("NostrJavaRelayClient is closed for relay: " + this.relayUrl);
        }
    }

    private void checkConnected() {
        if (!this.connected) {
            throw new IllegalStateException("NostrJavaRelayClient is not connected to relay: " + this.relayUrl + " - call connect() first");
        }
    }

    private class SubscriptionHandle
    implements AutoCloseable {
        private final String subscriptionId;
        private final AutoCloseable webSocketSubscription;
        private final String name;
        private volatile boolean closed = false;

        SubscriptionHandle(String subscriptionId, AutoCloseable webSocketSubscription, String name) {
            this.subscriptionId = subscriptionId;
            this.webSocketSubscription = webSocketSubscription;
            this.name = name;
        }

        @Override
        public void close() throws Exception {
            if (this.closed) {
                return;
            }
            log.debug("Closing subscription: " + this.name + " - ID: " + this.subscriptionId);
            CompletableFuture.runAsync(() -> {
                try {
                    CloseMessage closeMessage = new CloseMessage(this.subscriptionId);
                    NostrJavaRelayClient.this.webSocketClient.send(closeMessage);
                }
                catch (Exception e) {
                    log.debug("CLOSE handshake failed for subscription {}: {}", (Object)this.name, (Object)e.getMessage());
                }
            });
            try {
                this.webSocketSubscription.close();
            }
            catch (Exception e) {
                log.warn("Error closing WebSocket subscription: " + this.name + " - " + e.getMessage());
            }
            NostrJavaRelayClient.this.activeSubscriptions.remove(this.subscriptionId);
            NostrJavaRelayClient.this.subscriptionReadyLatches.remove(this.subscriptionId);
            this.closed = true;
            log.debug("Closed subscription: " + this.name + " - ID: " + this.subscriptionId);
        }
    }

    public static class RelaySubscribeException
    extends RuntimeException {
        private final String relayUrl;
        private final boolean retryable;

        public RelaySubscribeException(String message, Throwable cause) {
            super(message, cause);
            this.relayUrl = NostrJavaRelayClient.extractRelayUrlFromMessage(message);
            this.retryable = cause instanceof IOException;
        }

        public String getRelayUrl() {
            return this.relayUrl;
        }

        public boolean isRetryable() {
            return this.retryable;
        }
    }

    public static class RelayPublishException
    extends RuntimeException {
        private final String relayUrl;
        private final boolean retryable;

        public RelayPublishException(String message, Throwable cause) {
            super(message, cause);
            this.relayUrl = NostrJavaRelayClient.extractRelayUrlFromMessage(message);
            this.retryable = cause instanceof IOException;
        }

        public String getRelayUrl() {
            return this.relayUrl;
        }

        public boolean isRetryable() {
            return this.retryable;
        }
    }

    public static class RelayConnectionException
    extends RuntimeException {
        private final String relayUrl;

        public RelayConnectionException(String message, Throwable cause) {
            super(message, cause);
            this.relayUrl = NostrJavaRelayClient.extractRelayUrlFromMessage(message);
        }

        public String getRelayUrl() {
            return this.relayUrl;
        }

        public RelayUnavailableException toRelayUnavailableException() {
            return new RelayUnavailableException(this.relayUrl, this.getCause());
        }
    }
}

