/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.adapter;

import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.wallet.core.nostr.NostrRelayClient;
import xyz.tcheeric.wallet.core.nostr.NostrRelayClientFactory;
import xyz.tcheeric.wallet.core.nostr.NostrRelayOption;
import xyz.tcheeric.wallet.core.nostr.adapter.NostrJavaRelayClient;
import xyz.tcheeric.wallet.core.nostr.dm.Nip42AuthProvider;
import xyz.tcheeric.wallet.core.security.IdentityKey;
import xyz.tcheeric.wallet.core.security.WalletSigningKey;

public class NostrJavaRelayClientFactory
implements NostrRelayClientFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NostrJavaRelayClientFactory.class);
    private final Nip42AuthProvider authProvider;

    public NostrJavaRelayClientFactory() {
        this(null);
    }

    public NostrJavaRelayClientFactory(Nip42AuthProvider authProvider) {
        this.authProvider = authProvider;
    }

    @Override
    public NostrRelayClient create(NostrRelayOption option, IdentityKey identityKey, WalletSigningKey walletSigningKey) {
        NostrJavaRelayClient client;
        Objects.requireNonNull(option, "option cannot be null");
        Objects.requireNonNull(identityKey, "identityKey cannot be null");
        Objects.requireNonNull(walletSigningKey, "walletSigningKey cannot be null");
        log.debug("Creating NostrJavaRelayClient for relay: " + option.url());
        NostrJavaRelayClient nostrJavaRelayClient = client = this.authProvider != null ? new NostrJavaRelayClient(option.url(), this.authProvider) : new NostrJavaRelayClient(option.url());
        if (option.requiresAuth()) {
            log.debug("Enabling NIP-42 authentication for relay: " + option.url());
            client.enableAuth(identityKey, walletSigningKey);
        }
        log.debug("Created NostrJavaRelayClient for relay: " + option.url() + " (auth: " + option.requiresAuth() + ", read: " + option.canRead() + ", write: " + option.canWrite() + ")");
        return client;
    }
}

