/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.adapter;

import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import nostr.client.springwebsocket.SpringWebSocketClient;
import nostr.client.springwebsocket.StandardWebSocketClient;
import nostr.client.springwebsocket.WebSocketClientIF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertiesPropertySource;

public class SpringContextFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringContextFactory.class);
    private static final ConcurrentMap<String, PooledEntry> POOL = new ConcurrentHashMap<String, PooledEntry>();

    private SpringContextFactory() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static ManagedSpringContext createContextForRelay(String relayUrl) {
        if (relayUrl == null || relayUrl.isBlank()) {
            throw new IllegalArgumentException("Relay URL cannot be null or blank");
        }
        log.debug("Creating Spring context for relay: " + relayUrl);
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext();
        context.getEnvironment().getPropertySources().addLast(new PropertiesPropertySource("systemProperties", System.getProperties()));
        Properties relayProps = new Properties();
        relayProps.setProperty("nostr.relay.uri", relayUrl);
        context.getEnvironment().getPropertySources().addFirst(new PropertiesPropertySource("relayConfig", relayProps));
        String awaitTimeout = context.getEnvironment().getProperty("nostr.websocket.await-timeout-ms");
        String pollInterval = context.getEnvironment().getProperty("nostr.websocket.poll-interval-ms");
        log.info("Spring context for relay {} will use timeout properties: await={}ms, poll={}ms", relayUrl, awaitTimeout, pollInterval);
        context.register(NostrWebSocketConfiguration.class);
        context.setAllowBeanDefinitionOverriding(false);
        context.setAllowCircularReferences(false);
        context.refresh();
        log.debug("Spring context created for relay: " + relayUrl);
        SpringWebSocketClient client = context.getBean(SpringWebSocketClient.class);
        return new ManagedSpringContext(context, client);
    }

    public static ManagedSpringContext acquirePooledContextForRelay(String relayUrl) {
        if (relayUrl == null || relayUrl.isBlank()) {
            throw new IllegalArgumentException("Relay URL cannot be null or blank");
        }
        PooledEntry entry = POOL.compute(relayUrl, (key, existing) -> {
            if (existing == null || existing.context().isClosed()) {
                ManagedSpringContext created = SpringContextFactory.createContextForRelay(key);
                return new PooledEntry(created, new AtomicInteger(1));
            }
            existing.refs().incrementAndGet();
            return existing;
        });
        return new PooledManagedSpringContext(relayUrl, entry.context());
    }

    @Configuration
    static class NostrWebSocketConfiguration {
        NostrWebSocketConfiguration() {
        }

        @Bean
        public WebSocketClientIF webSocketClientIF(@Value(value="${nostr.relay.uri}") String relayUrl, Environment environment2) throws Exception {
            long awaitTimeoutMs = Long.parseLong(environment2.getProperty("nostr.websocket.await-timeout-ms", "60000"));
            long pollIntervalMs = Long.parseLong(environment2.getProperty("nostr.websocket.poll-interval-ms", "500"));
            log.info("Creating StandardWebSocketClient for {} with await={}ms, poll={}ms", relayUrl, awaitTimeoutMs, pollIntervalMs);
            return new StandardWebSocketClient(relayUrl, awaitTimeoutMs, pollIntervalMs);
        }

        @Bean
        public SpringWebSocketClient springWebSocketClient(WebSocketClientIF webSocketClientIF, @Value(value="${nostr.relay.uri}") String relayUrl) {
            return new SpringWebSocketClient(webSocketClientIF, relayUrl);
        }
    }

    public static class ManagedSpringContext
    implements AutoCloseable {
        private final GenericApplicationContext context;
        private final SpringWebSocketClient client;
        private volatile boolean closed = false;

        ManagedSpringContext(GenericApplicationContext context, SpringWebSocketClient client) {
            this.context = context;
            this.client = client;
        }

        public SpringWebSocketClient getClient() {
            if (this.closed) {
                throw new IllegalStateException("Context is closed");
            }
            return this.client;
        }

        public GenericApplicationContext getContext() {
            return this.context;
        }

        @Override
        public void close() {
            if (this.closed) {
                return;
            }
            log.debug("Closing Spring context for relay: " + this.client.getRelayUrl());
            try {
                if (this.client != null) {
                    this.client.close();
                }
            }
            catch (Exception e) {
                log.warn("Error closing WebSocket client: " + e.getMessage());
            }
            try {
                this.context.close();
            }
            catch (Exception e) {
                log.warn("Error closing Spring context: " + e.getMessage());
            }
            this.closed = true;
            log.debug("Spring context closed for relay: " + this.client.getRelayUrl());
        }

        public boolean isClosed() {
            return this.closed;
        }
    }

    private record PooledEntry(ManagedSpringContext context, AtomicInteger refs) {
    }

    static class PooledManagedSpringContext
    extends ManagedSpringContext {
        private final String relayUrl;
        private volatile boolean locallyClosed = false;

        PooledManagedSpringContext(String relayUrl, ManagedSpringContext delegate) {
            super(delegate.getContext(), delegate.getClient());
            this.relayUrl = relayUrl;
        }

        @Override
        public void close() {
            if (this.locallyClosed) {
                return;
            }
            this.locallyClosed = true;
            POOL.computeIfPresent(this.relayUrl, (key, entry) -> {
                int remaining = entry.refs().decrementAndGet();
                if (remaining <= 0) {
                    try {
                        entry.context().close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return null;
                }
                return entry;
            });
        }

        @Override
        public boolean isClosed() {
            return this.locallyClosed;
        }
    }
}

