/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.cashu;

import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.Size;
import java.time.Instant;
import xyz.tcheeric.wallet.core.nostr.cashu.WalletHistoryType;
import xyz.tcheeric.wallet.core.validation.CashuUnit;

public final class WalletHistoryEntry {
    @NotNull
    private final Instant timestamp;
    @NotNull
    private final WalletHistoryType type;
    @CashuUnit
    private final String unit;
    @Positive
    private final long amount;
    @Size(max=512)
    private final @Size(max=512) String memo;
    @Size(max=256)
    private final @Size(max=256) String mintUrl;

    public WalletHistoryEntry(Instant timestamp, WalletHistoryType type, String unit, long amount, String memo, String mintUrl) {
        this.timestamp = timestamp;
        this.type = type;
        this.unit = unit;
        this.amount = amount;
        this.memo = memo;
        this.mintUrl = mintUrl;
    }

    public Instant timestamp() {
        return this.timestamp;
    }

    public WalletHistoryType type() {
        return this.type;
    }

    public String unit() {
        return this.unit;
    }

    public long amount() {
        return this.amount;
    }

    public String memo() {
        return this.memo;
    }

    public String mintUrl() {
        return this.mintUrl;
    }
}

