/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.cashu;

import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import xyz.tcheeric.wallet.core.nostr.cashu.WalletSnapshotEntry;

public final class WalletSnapshot {
    @NotBlank
    @Pattern(regexp="^[0-9a-f]{64}$", message="pubkey must be 64 lowercase hex")
    private final @NotBlank @Pattern(regexp="^[0-9a-f]{64}$", message="pubkey must be 64 lowercase hex") String authorPubkeyHex;
    private final String identifier;
    @NotBlank
    private final String version;
    @NotNull
    private final Instant createdAt;
    @NotEmpty
    @Valid
    private final List<WalletSnapshotEntry> balances;

    public WalletSnapshot(String authorPubkeyHex, String identifier, String version, Instant createdAt, List<WalletSnapshotEntry> balances) {
        this.authorPubkeyHex = Objects.requireNonNull(authorPubkeyHex, "authorPubkeyHex").toLowerCase();
        this.identifier = identifier;
        this.version = Objects.requireNonNull(version, "version");
        this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
        this.balances = List.copyOf((Collection)Objects.requireNonNull(balances, "balances"));
    }

    public String authorPubkeyHex() {
        return this.authorPubkeyHex;
    }

    public String identifier() {
        return this.identifier;
    }

    public String version() {
        return this.version;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public List<WalletSnapshotEntry> balances() {
        return Collections.unmodifiableList(this.balances);
    }
}

