/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.cashu.mapper;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nostr.base.ElementAttribute;
import nostr.base.Kind;
import nostr.base.PublicKey;
import nostr.event.BaseTag;
import nostr.event.impl.GenericEvent;
import nostr.event.tag.GenericTag;
import nostr.event.tag.IdentifierTag;
import xyz.tcheeric.wallet.core.exception.HistoryParseException;
import xyz.tcheeric.wallet.core.nostr.cashu.WalletHistory;
import xyz.tcheeric.wallet.core.nostr.cashu.WalletHistoryEntry;
import xyz.tcheeric.wallet.core.nostr.cashu.WalletHistoryType;

public final class HistoryMapper {
    private static final ObjectMapper M = new ObjectMapper();
    private static final String SCHEMA_VERSION = "1";

    private HistoryMapper() {
    }

    public static GenericEvent toEvent(WalletHistory history) {
        Objects.requireNonNull(history, "history");
        GenericEvent ev = new GenericEvent();
        ev.setPubKey(new PublicKey(history.authorPubkeyHex()));
        ev.setKind(Kind.WALLET_TX_HISTORY.getValue());
        long createdAt = 0L;
        for (WalletHistoryEntry e : history.entries()) {
            long ts;
            if (e == null || e.timestamp() == null || (ts = e.timestamp().getEpochSecond()) <= createdAt) continue;
            createdAt = ts;
        }
        if (createdAt == 0L) {
            createdAt = Instant.now().getEpochSecond();
        }
        ev.setCreatedAt(createdAt);
        if (history.identifier() != null && !history.identifier().isBlank()) {
            ev.addTag(new IdentifierTag(history.identifier()));
        }
        ev.setContent(HistoryMapper.encodeContent(history));
        return ev;
    }

    public static WalletHistory fromEvent(GenericEvent event) throws HistoryParseException {
        try {
            if (event.getKind().intValue() != Kind.WALLET_TX_HISTORY.getValue()) {
                throw new HistoryParseException("unexpected kind=" + event.getKind());
            }
            String pubkey = event.getPubKey().toString();
            String identifier = event.getTags().stream().map(HistoryMapper::extractIdentifier).filter(Objects::nonNull).findFirst().orElse(null);
            JsonNode root = M.readTree(event.getContent());
            String v = HistoryMapper.getText(root, "v");
            ArrayList<WalletHistoryEntry> entries = new ArrayList<WalletHistoryEntry>();
            for (JsonNode n : HistoryMapper.requireArray(root, "entries")) {
                long ts = HistoryMapper.getLong(n, "t");
                String ty = HistoryMapper.getText(n, "ty");
                String u = HistoryMapper.getText(n, "u");
                long a = HistoryMapper.getLong(n, "a");
                String memo = HistoryMapper.getOptText(n, "m");
                String mint = HistoryMapper.getOptText(n, "mint");
                entries.add(new WalletHistoryEntry(Instant.ofEpochSecond(ts), WalletHistoryType.valueOf(ty), u, a, memo, mint));
            }
            return new WalletHistory(pubkey, identifier, v, entries);
        }
        catch (HistoryParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HistoryParseException(e.getMessage(), e);
        }
    }

    private static String encodeContent(WalletHistory h) {
        ObjectNode root = M.createObjectNode();
        root.put("v", h.version() != null ? h.version() : SCHEMA_VERSION);
        ArrayNode arr = M.createArrayNode();
        for (WalletHistoryEntry e : h.entries()) {
            ObjectNode n = M.createObjectNode();
            n.put("t", e.timestamp().getEpochSecond());
            n.put("ty", e.type().name());
            n.put("u", e.unit());
            n.put("a", e.amount());
            if (e.memo() != null) {
                n.put("m", e.memo());
            }
            if (e.mintUrl() != null) {
                n.put("mint", e.mintUrl());
            }
            arr.add(n);
        }
        root.set("entries", arr);
        return root.toString();
    }

    private static ArrayNode requireArray(JsonNode root, String field) throws HistoryParseException {
        JsonNode n = root.get(field);
        if (n == null || !n.isArray()) {
            throw new HistoryParseException("missing array field '" + field + "'");
        }
        return (ArrayNode)n;
    }

    private static String getText(JsonNode root, String field) throws HistoryParseException {
        JsonNode n = root.get(field);
        if (n == null || !n.isTextual()) {
            throw new HistoryParseException("missing text field '" + field + "'");
        }
        return n.asText();
    }

    private static String getOptText(JsonNode root, String field) {
        JsonNode n = root.get(field);
        return n != null && n.isTextual() ? n.asText() : null;
    }

    private static long getLong(JsonNode root, String field) throws HistoryParseException {
        JsonNode n = root.get(field);
        if (n == null || !n.canConvertToLong()) {
            throw new HistoryParseException("missing number field '" + field + "'");
        }
        return n.asLong();
    }

    private static String extractIdentifier(BaseTag tag) {
        if (tag instanceof IdentifierTag) {
            IdentifierTag identifierTag = (IdentifierTag)tag;
            return identifierTag.getUuid();
        }
        if (tag instanceof GenericTag) {
            GenericTag genericTag = (GenericTag)tag;
            try {
                List<ElementAttribute> attrs;
                if ("d".equals(genericTag.getCode()) && (attrs = genericTag.getAttributes()) != null && !attrs.isEmpty()) {
                    Object value = attrs.get(0).value();
                    return value != null ? value.toString() : null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

