/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.cashu.mapper;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nostr.base.ElementAttribute;
import nostr.base.Kind;
import nostr.base.PublicKey;
import nostr.event.BaseTag;
import nostr.event.impl.GenericEvent;
import nostr.event.tag.GenericTag;
import nostr.event.tag.IdentifierTag;
import xyz.tcheeric.wallet.core.exception.SnapshotParseException;
import xyz.tcheeric.wallet.core.nostr.cashu.WalletSnapshot;
import xyz.tcheeric.wallet.core.nostr.cashu.WalletSnapshotEntry;

public final class SnapshotMapper {
    private static final ObjectMapper M = new ObjectMapper();
    private static final String SCHEMA_VERSION = "1";

    private SnapshotMapper() {
    }

    public static GenericEvent toEvent(WalletSnapshot snapshot) {
        Objects.requireNonNull(snapshot, "snapshot");
        GenericEvent ev = new GenericEvent();
        String authorHex = snapshot.authorPubkeyHex();
        ev.setPubKey(new PublicKey(authorHex));
        ev.setKind(Kind.WALLET.getValue());
        ev.setCreatedAt(snapshot.createdAt().getEpochSecond());
        if (snapshot.identifier() != null && !snapshot.identifier().isBlank()) {
            ev.addTag(new IdentifierTag(snapshot.identifier()));
        }
        ev.setContent(SnapshotMapper.encodeContent(snapshot));
        return ev;
    }

    public static WalletSnapshot fromEvent(GenericEvent event) throws SnapshotParseException {
        try {
            if (event.getKind().intValue() != Kind.WALLET.getValue()) {
                throw new SnapshotParseException("unexpected kind=" + event.getKind());
            }
            String pubkey = event.getPubKey().toString();
            String identifier = event.getTags().stream().map(SnapshotMapper::extractIdentifier).filter(Objects::nonNull).findFirst().orElse(null);
            Instant created = Instant.ofEpochSecond(event.getCreatedAt());
            JsonNode root = M.readTree(event.getContent());
            String v = SnapshotMapper.getText(root, "v");
            if (!SCHEMA_VERSION.equals(v)) {
                // empty if block
            }
            ArrayList<WalletSnapshotEntry> entries = new ArrayList<WalletSnapshotEntry>();
            for (JsonNode n : SnapshotMapper.requireArray(root, "balances")) {
                String unit = SnapshotMapper.getText(n, "u");
                long amount = SnapshotMapper.getLong(n, "a");
                entries.add(new WalletSnapshotEntry(unit, amount));
            }
            return new WalletSnapshot(pubkey, identifier, v, created, entries);
        }
        catch (SnapshotParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SnapshotParseException(e.getMessage(), e);
        }
    }

    private static String encodeContent(WalletSnapshot s) {
        ObjectNode root = M.createObjectNode();
        root.put("v", s.version() != null ? s.version() : SCHEMA_VERSION);
        ArrayNode balances = M.createArrayNode();
        for (WalletSnapshotEntry e : s.balances()) {
            ObjectNode en = M.createObjectNode();
            en.put("u", e.unit());
            en.put("a", e.amount());
            balances.add(en);
        }
        root.set("balances", balances);
        return root.toString();
    }

    private static ArrayNode requireArray(JsonNode root, String field) throws SnapshotParseException {
        JsonNode n = root.get(field);
        if (n == null || !n.isArray()) {
            throw new SnapshotParseException("missing array field '" + field + "'");
        }
        return (ArrayNode)n;
    }

    private static String getText(JsonNode root, String field) throws SnapshotParseException {
        JsonNode n = root.get(field);
        if (n == null || !n.isTextual()) {
            throw new SnapshotParseException("missing text field '" + field + "'");
        }
        return n.asText();
    }

    private static long getLong(JsonNode root, String field) throws SnapshotParseException {
        JsonNode n = root.get(field);
        if (n == null || !n.canConvertToLong()) {
            throw new SnapshotParseException("missing number field '" + field + "'");
        }
        return n.asLong();
    }

    private static String extractIdentifier(BaseTag tag) {
        if (tag instanceof IdentifierTag) {
            IdentifierTag identifierTag = (IdentifierTag)tag;
            return identifierTag.getUuid();
        }
        if (tag instanceof GenericTag) {
            GenericTag genericTag = (GenericTag)tag;
            try {
                List<ElementAttribute> attrs;
                if ("d".equals(genericTag.getCode()) && (attrs = genericTag.getAttributes()) != null && !attrs.isEmpty()) {
                    Object value = attrs.get(0).value();
                    return value != null ? value.toString() : null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

