/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.cashu.service;

import java.util.Collection;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.wallet.core.nostr.NostrEvent;
import xyz.tcheeric.wallet.core.nostr.NostrGatewayService;
import xyz.tcheeric.wallet.core.nostr.adapter.NostrEventAdapter;
import xyz.tcheeric.wallet.core.nostr.cashu.WalletHistory;
import xyz.tcheeric.wallet.core.nostr.cashu.WalletSnapshot;
import xyz.tcheeric.wallet.core.nostr.cashu.mapper.HistoryMapper;
import xyz.tcheeric.wallet.core.nostr.cashu.mapper.SnapshotMapper;
import xyz.tcheeric.wallet.core.observability.WalletMetrics;

public final class CashuNipPublisher {
    private static final Logger LOGGER = LoggerFactory.getLogger(CashuNipPublisher.class);
    private final NostrGatewayService gateway;

    public CashuNipPublisher(NostrGatewayService gateway) {
        this.gateway = Objects.requireNonNull(gateway, "gateway");
    }

    public void publishSnapshot(WalletSnapshot snapshot) {
        Objects.requireNonNull(snapshot, "snapshot");
        NostrEvent ev = NostrEventAdapter.toWalletEvent(SnapshotMapper.toEvent(snapshot));
        try {
            this.gateway.publish(ev);
            WalletMetrics.getInstance().recordSnapshotPublishSuccess();
            LOGGER.info("cashu_nip publisher snapshot_published author={} id={} balances={} outcome=success", snapshot.authorPubkeyHex(), snapshot.identifier(), snapshot.balances().size());
        }
        catch (RuntimeException e) {
            WalletMetrics.getInstance().recordSnapshotPublishFailure();
            LOGGER.error("cashu_nip publisher snapshot_publish_failed author={} id={} reason={} outcome=failed", snapshot.authorPubkeyHex(), snapshot.identifier(), e.getMessage(), e);
            throw e;
        }
    }

    public void publishSnapshot(WalletSnapshot snapshot, Collection<String> relayUrls) {
        Objects.requireNonNull(snapshot, "snapshot");
        NostrEvent ev = NostrEventAdapter.toWalletEvent(SnapshotMapper.toEvent(snapshot));
        try {
            this.gateway.publish(ev, relayUrls);
            WalletMetrics.getInstance().recordSnapshotPublishSuccess();
            LOGGER.info("cashu_nip publisher snapshot_published author={} id={} relay_count={} outcome=success", snapshot.authorPubkeyHex(), snapshot.identifier(), relayUrls != null ? relayUrls.size() : 0);
        }
        catch (RuntimeException e) {
            WalletMetrics.getInstance().recordSnapshotPublishFailure();
            LOGGER.error("cashu_nip publisher snapshot_publish_failed author={} id={} reason={} outcome=failed", snapshot.authorPubkeyHex(), snapshot.identifier(), e.getMessage(), e);
            throw e;
        }
    }

    public void publishHistory(WalletHistory history) {
        Objects.requireNonNull(history, "history");
        NostrEvent ev = NostrEventAdapter.toWalletEvent(HistoryMapper.toEvent(history));
        try {
            this.gateway.publish(ev);
            WalletMetrics.getInstance().recordHistoryPublishSuccess();
            LOGGER.info("cashu_nip publisher history_published author={} id={} entries={} outcome=success", history.authorPubkeyHex(), history.identifier(), history.entries().size());
        }
        catch (RuntimeException e) {
            WalletMetrics.getInstance().recordHistoryPublishFailure();
            LOGGER.error("cashu_nip publisher history_publish_failed author={} id={} reason={} outcome=failed", history.authorPubkeyHex(), history.identifier(), e.getMessage(), e);
            throw e;
        }
    }

    public void publishHistory(WalletHistory history, Collection<String> relayUrls) {
        Objects.requireNonNull(history, "history");
        NostrEvent ev = NostrEventAdapter.toWalletEvent(HistoryMapper.toEvent(history));
        try {
            this.gateway.publish(ev, relayUrls);
            WalletMetrics.getInstance().recordHistoryPublishSuccess();
            LOGGER.info("cashu_nip publisher history_published author={} id={} relay_count={} outcome=success", history.authorPubkeyHex(), history.identifier(), relayUrls != null ? relayUrls.size() : 0);
        }
        catch (RuntimeException e) {
            WalletMetrics.getInstance().recordHistoryPublishFailure();
            LOGGER.error("cashu_nip publisher history_publish_failed author={} id={} reason={} outcome=failed", history.authorPubkeyHex(), history.identifier(), e.getMessage(), e);
            throw e;
        }
    }
}

