/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.cashu.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import nostr.base.Kind;
import nostr.event.impl.GenericEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.wallet.core.nostr.NostrEvent;
import xyz.tcheeric.wallet.core.nostr.NostrGatewayService;
import xyz.tcheeric.wallet.core.nostr.adapter.NostrEventAdapter;
import xyz.tcheeric.wallet.core.nostr.cashu.WalletHistory;
import xyz.tcheeric.wallet.core.nostr.cashu.WalletHistoryEntry;
import xyz.tcheeric.wallet.core.nostr.cashu.WalletHistoryType;
import xyz.tcheeric.wallet.core.nostr.cashu.WalletSnapshot;
import xyz.tcheeric.wallet.core.nostr.cashu.WalletSnapshotEntry;
import xyz.tcheeric.wallet.core.nostr.cashu.mapper.HistoryMapper;
import xyz.tcheeric.wallet.core.nostr.cashu.mapper.SnapshotMapper;
import xyz.tcheeric.wallet.core.nostr.filter.NostrFilterBuilder;
import xyz.tcheeric.wallet.core.nostr.filter.NostrServerSideFilter;
import xyz.tcheeric.wallet.core.observability.WalletMetrics;

public final class CashuNipReader {
    private final NostrGatewayService gateway;
    private static final Logger LOGGER = LoggerFactory.getLogger(CashuNipReader.class);

    public CashuNipReader(NostrGatewayService gateway) {
        this.gateway = Objects.requireNonNull(gateway, "gateway");
    }

    public AutoCloseable openSnapshotSubscription(String name, String authorPubkeyHex, String identifier, Consumer<WalletSnapshot> consumer) {
        NostrServerSideFilter filter2 = this.buildSnapshotFilter(authorPubkeyHex, identifier);
        return this.gateway.subscribe(name, filter2, this.wrapSnapshotConsumer(consumer));
    }

    public AutoCloseable openSnapshotSubscription(Collection<String> relays, String name, String authorPubkeyHex, String identifier, Consumer<WalletSnapshot> consumer) {
        NostrServerSideFilter filter2 = this.buildSnapshotFilter(authorPubkeyHex, identifier);
        return this.gateway.subscribe(relays, name, filter2, this.wrapSnapshotConsumer(consumer));
    }

    public AutoCloseable openHistorySubscription(String name, String authorPubkeyHex, String identifier, Instant since, Instant until, Consumer<WalletHistory> consumer) {
        NostrServerSideFilter filter2 = this.buildHistoryFilter(authorPubkeyHex, identifier, since, until);
        return this.gateway.subscribe(name, filter2, this.wrapHistoryConsumer(consumer));
    }

    public AutoCloseable openHistorySubscription(Collection<String> relays, String name, String authorPubkeyHex, String identifier, Instant since, Instant until, Consumer<WalletHistory> consumer) {
        NostrServerSideFilter filter2 = this.buildHistoryFilter(authorPubkeyHex, identifier, since, until);
        return this.gateway.subscribe(relays, name, filter2, this.wrapHistoryConsumer(consumer));
    }

    private NostrServerSideFilter buildSnapshotFilter(String author, String identifier) {
        NostrFilterBuilder b = NostrFilterBuilder.newBuilder().authors(author).kinds(Kind.WALLET).limit(100);
        if (identifier != null && !identifier.isBlank()) {
            b.identifiers(identifier);
        }
        return b.build();
    }

    private NostrServerSideFilter buildHistoryFilter(String author, String identifier, Instant since, Instant until) {
        NostrFilterBuilder b = NostrFilterBuilder.newBuilder().authors(author).kinds(Kind.WALLET_TX_HISTORY).limit(500);
        if (identifier != null && !identifier.isBlank()) {
            b.identifiers(identifier);
        }
        if (since != null) {
            b.since(since);
        }
        if (until != null) {
            b.until(until);
        }
        return b.build();
    }

    private Consumer<NostrEvent> wrapSnapshotConsumer(Consumer<WalletSnapshot> consumer) {
        return ev -> {
            try {
                GenericEvent ge = NostrEventAdapter.toNostrJavaEvent(ev);
                WalletSnapshot s = SnapshotMapper.fromEvent(ge);
                WalletMetrics.getInstance().recordSnapshotReceived();
                LOGGER.debug("cashu_nip reader snapshot_received author={} id={} balances={} outcome=accepted", s.authorPubkeyHex(), s.identifier(), s.balances().size());
                consumer.accept(s);
            }
            catch (Exception ignored) {
                try {
                    WalletSnapshot s = this.fallbackSnapshotFromWalletEvent((NostrEvent)ev);
                    WalletMetrics.getInstance().recordSnapshotReceived();
                    LOGGER.debug("cashu_nip reader snapshot_received_fallback author={} id={} balances={} outcome=accepted", s.authorPubkeyHex(), s.identifier(), s.balances().size());
                    consumer.accept(s);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
    }

    private Consumer<NostrEvent> wrapHistoryConsumer(Consumer<WalletHistory> consumer) {
        return ev -> {
            try {
                GenericEvent ge = NostrEventAdapter.toNostrJavaEvent(ev);
                WalletHistory h = HistoryMapper.fromEvent(ge);
                WalletMetrics.getInstance().recordHistoryReceived();
                LOGGER.debug("cashu_nip reader history_received author={} id={} entries={} outcome=accepted", h.authorPubkeyHex(), h.identifier(), h.entries().size());
                consumer.accept(h);
            }
            catch (Exception ignored) {
                try {
                    WalletHistory h = this.fallbackHistoryFromWalletEvent((NostrEvent)ev);
                    WalletMetrics.getInstance().recordHistoryReceived();
                    LOGGER.debug("cashu_nip reader history_received_fallback author={} id={} entries={} outcome=accepted", h.authorPubkeyHex(), h.identifier(), h.entries().size());
                    consumer.accept(h);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
    }

    private WalletSnapshot fallbackSnapshotFromWalletEvent(NostrEvent ev) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode root = mapper.readTree(ev.content());
        String v = root.path("v").asText("1");
        ArrayList<WalletSnapshotEntry> balances = new ArrayList<WalletSnapshotEntry>();
        for (JsonNode n : root.path("balances")) {
            String unit = n.path("u").asText();
            long amount = n.path("a").asLong();
            balances.add(new WalletSnapshotEntry(unit, amount));
        }
        String identifier = null;
        for (List<String> tag : ev.tags()) {
            if (tag.isEmpty() || !"d".equals(tag.get(0)) || tag.size() < 2) continue;
            identifier = tag.get(1);
            break;
        }
        return new WalletSnapshot(ev.pubkey(), identifier, v, ev.createdAt(), balances);
    }

    private WalletHistory fallbackHistoryFromWalletEvent(NostrEvent ev) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode root = mapper.readTree(ev.content());
        String v = root.path("v").asText("1");
        ArrayList<WalletHistoryEntry> entries = new ArrayList<WalletHistoryEntry>();
        for (JsonNode n : root.path("entries")) {
            long ts = n.path("t").asLong(ev.createdAt() != null ? ev.createdAt().getEpochSecond() : Instant.now().getEpochSecond());
            String ty = n.path("ty").asText("MINT");
            String u = n.path("u").asText("sat");
            long a = n.path("a").asLong(0L);
            String memo = n.has("m") ? n.path("m").asText(null) : null;
            String mint = n.has("mint") ? n.path("mint").asText(null) : null;
            entries.add(new WalletHistoryEntry(Instant.ofEpochSecond(ts), WalletHistoryType.valueOf(ty), u, a, memo, mint));
        }
        String identifier = null;
        for (List<String> tag : ev.tags()) {
            if (tag.isEmpty() || !"d".equals(tag.get(0)) || tag.size() < 2) continue;
            identifier = tag.get(1);
            break;
        }
        return new WalletHistory(ev.pubkey(), identifier, v, entries);
    }
}

