/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.filter;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import nostr.base.GenericTagQuery;
import nostr.base.Kind;
import nostr.base.PublicKey;
import nostr.base.Relay;
import nostr.event.filter.AddressTagFilter;
import nostr.event.filter.AuthorFilter;
import nostr.event.filter.EventFilter;
import nostr.event.filter.Filterable;
import nostr.event.filter.Filters;
import nostr.event.filter.GenericTagQueryFilter;
import nostr.event.filter.GeohashTagFilter;
import nostr.event.filter.HashtagTagFilter;
import nostr.event.filter.IdentifierTagFilter;
import nostr.event.filter.KindFilter;
import nostr.event.filter.ReferencedEventFilter;
import nostr.event.filter.ReferencedPublicKeyFilter;
import nostr.event.filter.SinceFilter;
import nostr.event.filter.UntilFilter;
import nostr.event.filter.UrlTagFilter;
import nostr.event.filter.VoteTagFilter;
import nostr.event.impl.GenericEvent;
import nostr.event.tag.AddressTag;
import nostr.event.tag.EventTag;
import nostr.event.tag.GeohashTag;
import nostr.event.tag.HashtagTag;
import nostr.event.tag.IdentifierTag;
import nostr.event.tag.PubKeyTag;
import nostr.event.tag.UrlTag;
import nostr.event.tag.VoteTag;
import xyz.tcheeric.wallet.core.nostr.filter.NostrServerSideFilter;

public final class NostrFilterBuilder {
    private final List<Filterable> currentGroup = new ArrayList<Filterable>();
    private final List<Filters> groups = new ArrayList<Filters>();
    private Integer limit;

    private NostrFilterBuilder() {
    }

    public static NostrFilterBuilder newBuilder() {
        return new NostrFilterBuilder();
    }

    public NostrFilterBuilder kinds(int ... kinds) {
        Objects.requireNonNull(kinds, "kinds");
        for (int k : kinds) {
            this.currentGroup.add(new KindFilter<Kind>(Kind.valueOf(k)));
        }
        return this;
    }

    public NostrFilterBuilder kinds(Kind ... kinds) {
        Objects.requireNonNull(kinds, "kinds");
        for (Kind k : kinds) {
            if (k == null) continue;
            this.currentGroup.add(new KindFilter<Kind>(k));
        }
        return this;
    }

    public NostrFilterBuilder authors(String ... pubkeyHex) {
        Objects.requireNonNull(pubkeyHex, "pubkeyHex");
        for (String hex : pubkeyHex) {
            if (hex == null || hex.isBlank()) continue;
            this.currentGroup.add(new AuthorFilter<PublicKey>(new PublicKey(NostrFilterBuilder.normalizeHex64(hex))));
        }
        return this;
    }

    public NostrFilterBuilder identifiers(String ... identifiers) {
        Objects.requireNonNull(identifiers, "identifiers");
        for (String id : identifiers) {
            if (id == null || id.isBlank()) continue;
            this.currentGroup.add(new IdentifierTagFilter<IdentifierTag>(new IdentifierTag(id)));
        }
        return this;
    }

    public NostrFilterBuilder address(int kind, String pubkeyHex, String identifier) {
        Objects.requireNonNull(pubkeyHex, "pubkeyHex");
        Objects.requireNonNull(identifier, "identifier");
        AddressTag tag = new AddressTag(kind, new PublicKey(NostrFilterBuilder.normalizeHex64(pubkeyHex)), new IdentifierTag(identifier), null);
        this.currentGroup.add(new AddressTagFilter<AddressTag>(tag));
        return this;
    }

    public NostrFilterBuilder address(int kind, String pubkeyHex, String identifier, String relayUrl) {
        Objects.requireNonNull(pubkeyHex, "pubkeyHex");
        Objects.requireNonNull(identifier, "identifier");
        Objects.requireNonNull(relayUrl, "relayUrl");
        AddressTag tag = new AddressTag(kind, new PublicKey(NostrFilterBuilder.normalizeHex64(pubkeyHex)), new IdentifierTag(identifier), new Relay(relayUrl));
        this.currentGroup.add(new AddressTagFilter<AddressTag>(tag));
        return this;
    }

    public NostrFilterBuilder ids(String ... eventIds) {
        Objects.requireNonNull(eventIds, "eventIds");
        for (String id : eventIds) {
            if (id == null || id.isBlank()) continue;
            this.currentGroup.add(new EventFilter<GenericEvent>(new GenericEvent(NostrFilterBuilder.normalizeHex64(id))));
        }
        return this;
    }

    public NostrFilterBuilder since(Instant since) {
        Objects.requireNonNull(since, "since");
        this.currentGroup.add(new SinceFilter(since.getEpochSecond()));
        return this;
    }

    public NostrFilterBuilder until(Instant until) {
        Objects.requireNonNull(until, "until");
        this.currentGroup.add(new UntilFilter(until.getEpochSecond()));
        return this;
    }

    public NostrFilterBuilder limit(int limit) {
        if (limit <= 0) {
            throw new IllegalArgumentException("limit must be positive");
        }
        this.limit = limit;
        return this;
    }

    public NostrFilterBuilder referencedEvents(String ... eventIds) {
        Objects.requireNonNull(eventIds, "eventIds");
        for (String id : eventIds) {
            if (id == null || id.isBlank()) continue;
            this.currentGroup.add(new ReferencedEventFilter<EventTag>(new EventTag(NostrFilterBuilder.normalizeHex64(id))));
        }
        return this;
    }

    public NostrFilterBuilder referencedPubKeys(String ... pubkeyHex) {
        Objects.requireNonNull(pubkeyHex, "pubkeyHex");
        for (String hex : pubkeyHex) {
            if (hex == null || hex.isBlank()) continue;
            this.currentGroup.add(new ReferencedPublicKeyFilter<PubKeyTag>(new PubKeyTag(new PublicKey(NostrFilterBuilder.normalizeHex64(hex)))));
        }
        return this;
    }

    public NostrFilterBuilder hashtags(String ... tags) {
        Objects.requireNonNull(tags, "tags");
        for (String t : tags) {
            if (t == null || t.isBlank()) continue;
            this.currentGroup.add(new HashtagTagFilter<HashtagTag>(new HashtagTag(t)));
        }
        return this;
    }

    public NostrFilterBuilder tag(String tagCodeWithHash, String value) {
        Objects.requireNonNull(tagCodeWithHash, "tagCodeWithHash");
        Objects.requireNonNull(value, "value");
        this.currentGroup.add(new GenericTagQueryFilter<GenericTagQuery>(new GenericTagQuery(tagCodeWithHash, value)));
        return this;
    }

    public NostrFilterBuilder geohashes(String ... geohashes) {
        Objects.requireNonNull(geohashes, "geohashes");
        for (String g : geohashes) {
            if (g == null || g.isBlank()) continue;
            this.currentGroup.add(new GeohashTagFilter<GeohashTag>(new GeohashTag(g)));
        }
        return this;
    }

    public NostrFilterBuilder urls(String ... urls2) {
        Objects.requireNonNull(urls2, "urls");
        for (String u : urls2) {
            if (u == null || u.isBlank()) continue;
            this.currentGroup.add(new UrlTagFilter<UrlTag>(new UrlTag(u)));
        }
        return this;
    }

    public NostrFilterBuilder votes(int ... votes) {
        Objects.requireNonNull(votes, "votes");
        for (int v : votes) {
            this.currentGroup.add(new VoteTagFilter<VoteTag>(new VoteTag(v)));
        }
        return this;
    }

    public NostrFilterBuilder orGroup() {
        this.commitCurrentGroup();
        return this;
    }

    public NostrServerSideFilter build() {
        this.commitCurrentGroup();
        if (this.groups.isEmpty()) {
            throw new IllegalStateException("No filters configured");
        }
        return new NostrServerSideFilter(this.groups);
    }

    private void commitCurrentGroup() {
        if (this.currentGroup.isEmpty()) {
            return;
        }
        Filters f = new Filters(this.currentGroup);
        if (this.limit != null) {
            f.setLimit(this.limit);
        }
        this.groups.add(f);
        this.currentGroup.clear();
        this.limit = null;
    }

    public static NostrServerSideFilter textNotesByAuthorsSince(Collection<String> authorHex, Instant since, int limit) {
        Objects.requireNonNull(authorHex, "authorHex");
        Objects.requireNonNull(since, "since");
        String[] authors = (String[])authorHex.stream().filter(Objects::nonNull).map(NostrFilterBuilder::normalizeHex64).toArray(String[]::new);
        return NostrFilterBuilder.newBuilder().kinds(Kind.TEXT_NOTE).authors(authors).since(since).limit(limit).build();
    }

    public static NostrServerSideFilter eventsByIds(String ... eventIds) {
        Objects.requireNonNull(eventIds, "eventIds");
        String[] ids = (String[])Arrays.stream(eventIds).filter(Objects::nonNull).map(NostrFilterBuilder::normalizeHex64).toArray(String[]::new);
        return NostrFilterBuilder.newBuilder().ids(ids).build();
    }

    public static NostrServerSideFilter addressBy(int kind, String authorPubkeyHex, String identifier) {
        return NostrFilterBuilder.newBuilder().address(kind, NostrFilterBuilder.normalizeHex64(authorPubkeyHex), identifier).build();
    }

    public static NostrServerSideFilter addressBy(int kind, String authorPubkeyHex, String identifier, String relayUrl) {
        return NostrFilterBuilder.newBuilder().address(kind, NostrFilterBuilder.normalizeHex64(authorPubkeyHex), identifier, relayUrl).build();
    }

    private static String normalizeHex64(String hex) {
        String s = hex.trim();
        if (s.startsWith("0x") || s.startsWith("0X")) {
            s = s.substring(2);
        }
        if ((s = s.toLowerCase()).length() >= 64) {
            return s;
        }
        StringBuilder sb = new StringBuilder(64);
        for (int i2 = 0; i2 < 64 - s.length(); ++i2) {
            sb.append('0');
        }
        sb.append(s);
        return sb.toString();
    }
}

