/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.relay;

import java.time.Duration;
import java.time.Instant;
import java.util.Objects;

public record EvictedRelay(String relayUrl, Instant evictedAt, double evictionScore, int retryCount) {
    private static final int MAX_BACKOFF_SHIFT = 62;

    public EvictedRelay {
        Objects.requireNonNull(relayUrl, "relayUrl");
        Objects.requireNonNull(evictedAt, "evictedAt");
        if (evictionScore < 0.0 || evictionScore > 100.0) {
            throw new IllegalArgumentException("evictionScore must be between 0 and 100: " + evictionScore);
        }
        if (retryCount < 0) {
            throw new IllegalArgumentException("retryCount cannot be negative: " + retryCount);
        }
    }

    public static EvictedRelay create(String relayUrl, double evictionScore) {
        return new EvictedRelay(relayUrl, Instant.now(), evictionScore, 0);
    }

    public EvictedRelay withRetry() {
        return new EvictedRelay(this.relayUrl, this.evictedAt, this.evictionScore, this.retryCount + 1);
    }

    public boolean isEligibleForRetry(Duration retryInterval) {
        Objects.requireNonNull(retryInterval, "retryInterval");
        long multiplier = 1L << Math.min(this.retryCount, 62);
        Instant nextRetryTime = this.evictedAt.plus(retryInterval.multipliedBy(multiplier));
        return Instant.now().isAfter(nextRetryTime);
    }
}

