/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.relay;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import xyz.tcheeric.wallet.core.nostr.relay.RelayConnection;
import xyz.tcheeric.wallet.core.nostr.relay.RelaySelectionPolicy;

public class RandomRelayPolicy
implements RelaySelectionPolicy {
    private final Random random;

    public RandomRelayPolicy() {
        this(new SecureRandom());
    }

    public RandomRelayPolicy(Random random) {
        this.random = Objects.requireNonNull(random, "random");
    }

    @Override
    public List<RelayConnection> select(Collection<RelayConnection> availableRelays, int requestedCount, RelaySelectionPolicy.SelectionContext context) {
        Objects.requireNonNull(availableRelays, "availableRelays");
        Objects.requireNonNull(context, "context");
        if (availableRelays.isEmpty()) {
            throw new IllegalArgumentException("availableRelays cannot be empty");
        }
        if (requestedCount <= 0) {
            throw new IllegalArgumentException("requestedCount must be > 0, got: " + requestedCount);
        }
        ArrayList<RelayConnection> healthyRelays = new ArrayList<RelayConnection>();
        ArrayList<RelayConnection> degradedRelays = new ArrayList<RelayConnection>();
        for (RelayConnection relay : availableRelays) {
            if (!relay.isAvailable()) continue;
            if (relay.isHealthy()) {
                healthyRelays.add(relay);
                continue;
            }
            degradedRelays.add(relay);
        }
        Collections.shuffle(healthyRelays, this.random);
        Collections.shuffle(degradedRelays, this.random);
        ArrayList selected = new ArrayList(healthyRelays.subList(0, Math.min(requestedCount, healthyRelays.size())));
        int remaining = requestedCount - selected.size();
        if (remaining > 0 && !degradedRelays.isEmpty()) {
            int degradedCount = Math.min(remaining, degradedRelays.size());
            selected.addAll(degradedRelays.subList(0, degradedCount));
        }
        return List.copyOf(selected);
    }
}

