/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.relay;

import java.util.Objects;
import xyz.tcheeric.wallet.core.nostr.relay.RelayStatus;

public record RelayConnection(String url, RelayStatus status) {
    public RelayConnection {
        Objects.requireNonNull(url, "url");
        Objects.requireNonNull(status, "status");
        if (url.isBlank()) {
            throw new IllegalArgumentException("Relay URL cannot be blank");
        }
    }

    public static RelayConnection connected(String url) {
        return new RelayConnection(url, RelayStatus.CONNECTED);
    }

    public static RelayConnection degraded(String url) {
        return new RelayConnection(url, RelayStatus.DEGRADED);
    }

    public static RelayConnection disconnected(String url) {
        return new RelayConnection(url, RelayStatus.DISCONNECTED);
    }

    public boolean isAvailable() {
        return this.status == RelayStatus.CONNECTED || this.status == RelayStatus.DEGRADED;
    }

    public boolean isHealthy() {
        return this.status == RelayStatus.CONNECTED;
    }
}

