/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.relay;

import java.time.Duration;
import java.util.Objects;
import xyz.tcheeric.wallet.core.nostr.relay.RelayMetrics;
import xyz.tcheeric.wallet.core.nostr.relay.RelayStatus;

public class RelayHealthScorer {
    public static final Duration TARGET_LATENCY_SLO = Duration.ofMillis(500L);
    public static final Duration MAX_TOLERABLE_LATENCY = Duration.ofSeconds(5L);
    public static final double CONNECTED_THRESHOLD = 70.0;
    public static final double DEGRADED_THRESHOLD = 30.0;
    private static final double LATENCY_WEIGHT = 0.4;
    private static final double SUCCESS_RATE_WEIGHT = 0.4;
    private static final double AVAILABILITY_WEIGHT = 0.2;
    private final RelayMetrics metrics;

    public RelayHealthScorer(RelayMetrics metrics) {
        this.metrics = Objects.requireNonNull(metrics, "metrics");
    }

    public double calculateScore() {
        double latencyScore = this.calculateLatencyScore();
        double successRateScore = this.calculateSuccessRateScore();
        double availabilityScore = this.calculateAvailabilityScore();
        return latencyScore * 0.4 + successRateScore * 0.4 + availabilityScore * 0.2;
    }

    private double calculateLatencyScore() {
        Duration p95Latency = this.metrics.p95Latency();
        if (p95Latency == null || p95Latency.isNegative() || p95Latency.isZero()) {
            return 50.0;
        }
        long latencyMs = p95Latency.toMillis();
        long targetMs = TARGET_LATENCY_SLO.toMillis();
        long maxMs = MAX_TOLERABLE_LATENCY.toMillis();
        if (latencyMs <= targetMs) {
            return 100.0;
        }
        if (latencyMs >= maxMs) {
            return 0.0;
        }
        double ratio = (double)(latencyMs - targetMs) / (double)(maxMs - targetMs);
        return 100.0 * Math.exp(-3.0 * ratio);
    }

    private double calculateSuccessRateScore() {
        long total = this.metrics.totalOperations();
        long successes = this.metrics.successfulOperations();
        if (total == 0L) {
            return 50.0;
        }
        return 100.0 * ((double)successes / (double)total);
    }

    private double calculateAvailabilityScore() {
        long attempts = this.metrics.connectionAttempts();
        long successes = this.metrics.successfulConnections();
        if (attempts == 0L) {
            return 50.0;
        }
        return 100.0 * ((double)successes / (double)attempts);
    }

    public RelayStatus determineStatus() {
        double score = this.calculateScore();
        if (score >= 70.0) {
            return RelayStatus.CONNECTED;
        }
        if (score >= 30.0) {
            return RelayStatus.DEGRADED;
        }
        return RelayStatus.DISCONNECTED;
    }

    public RelayMetrics metrics() {
        return this.metrics;
    }

    public String toScoreSummary() {
        double overall = this.calculateScore();
        double latency = this.calculateLatencyScore();
        double successRate = this.calculateSuccessRateScore();
        double availability = this.calculateAvailabilityScore();
        RelayStatus status = this.determineStatus();
        return String.format("HealthScore[overall=%.1f, latency=%.1f, successRate=%.1f, availability=%.1f, status=%s]", new Object[]{overall, latency, successRate, availability, status});
    }
}

