/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.relay;

import java.time.Duration;
import java.time.Instant;
import java.util.Objects;

public record RelayMetrics(String relayUrl, Duration p95Latency, long successfulOperations, long totalOperations, long successfulConnections, long connectionAttempts, Instant capturedAt) {
    public RelayMetrics {
        Objects.requireNonNull(relayUrl, "relayUrl");
        Objects.requireNonNull(capturedAt, "capturedAt");
        if (successfulOperations < 0L) {
            throw new IllegalArgumentException("successfulOperations cannot be negative: " + successfulOperations);
        }
        if (totalOperations < 0L) {
            throw new IllegalArgumentException("totalOperations cannot be negative: " + totalOperations);
        }
        if (successfulOperations > totalOperations) {
            throw new IllegalArgumentException("successfulOperations (" + successfulOperations + ") cannot exceed totalOperations (" + totalOperations + ")");
        }
        if (successfulConnections < 0L) {
            throw new IllegalArgumentException("successfulConnections cannot be negative: " + successfulConnections);
        }
        if (connectionAttempts < 0L) {
            throw new IllegalArgumentException("connectionAttempts cannot be negative: " + connectionAttempts);
        }
        if (successfulConnections > connectionAttempts) {
            throw new IllegalArgumentException("successfulConnections (" + successfulConnections + ") cannot exceed connectionAttempts (" + connectionAttempts + ")");
        }
    }

    public static RelayMetrics initial(String relayUrl) {
        return new RelayMetrics(relayUrl, null, 0L, 0L, 0L, 0L, Instant.now());
    }

    public double failureRate() {
        if (this.totalOperations == 0L) {
            return 0.0;
        }
        long failures = this.totalOperations - this.successfulOperations;
        return (double)failures / (double)this.totalOperations;
    }

    public double successRate() {
        if (this.totalOperations == 0L) {
            return 0.0;
        }
        return (double)this.successfulOperations / (double)this.totalOperations;
    }

    public double connectionSuccessRate() {
        if (this.connectionAttempts == 0L) {
            return 0.0;
        }
        return (double)this.successfulConnections / (double)this.connectionAttempts;
    }

    public boolean hasSufficientData() {
        return this.connectionAttempts > 0L && this.totalOperations > 0L;
    }

    public RelayMetrics withOperation(boolean success, Duration latency) {
        return new RelayMetrics(this.relayUrl, latency != null ? latency : this.p95Latency, success ? this.successfulOperations + 1L : this.successfulOperations, this.totalOperations + 1L, this.successfulConnections, this.connectionAttempts, Instant.now());
    }

    public RelayMetrics withConnectionAttempt(boolean success) {
        return new RelayMetrics(this.relayUrl, this.p95Latency, this.successfulOperations, this.totalOperations, success ? this.successfulConnections + 1L : this.successfulConnections, this.connectionAttempts + 1L, Instant.now());
    }
}

