/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.relay;

import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.wallet.core.nostr.relay.EvictedRelay;

public class RelayReEvaluator {
    private static final Logger LOGGER = LoggerFactory.getLogger(RelayReEvaluator.class);
    public static final Duration DEFAULT_RETRY_INTERVAL = Duration.ofMinutes(5L);
    public static final int MAX_RETRY_COUNT = 5;
    private final ConcurrentHashMap<String, EvictedRelay> evictedRelays = new ConcurrentHashMap();
    private final Duration retryInterval;
    private final int maxRetryCount;

    public RelayReEvaluator() {
        this(DEFAULT_RETRY_INTERVAL, 5);
    }

    public RelayReEvaluator(Duration retryInterval, int maxRetryCount) {
        this.retryInterval = Objects.requireNonNull(retryInterval, "retryInterval");
        if (maxRetryCount < 0) {
            throw new IllegalArgumentException("maxRetryCount cannot be negative: " + maxRetryCount);
        }
        this.maxRetryCount = maxRetryCount;
        LOGGER.info("relay_re_evaluator initialized retry_interval={} max_retries={}", (Object)retryInterval, (Object)maxRetryCount);
    }

    public void evictRelay(String relayUrl, double evictionScore) {
        Objects.requireNonNull(relayUrl, "relayUrl");
        EvictedRelay evicted = EvictedRelay.create(relayUrl, evictionScore);
        this.evictedRelays.put(relayUrl, evicted);
        LOGGER.info("relay_re_evaluator relay_evicted url={} score={} outcome=tracking_for_retry", (Object)relayUrl, (Object)evictionScore);
    }

    public Map<String, EvictedRelay> getEligibleForRetry() {
        ConcurrentHashMap<String, EvictedRelay> eligible = new ConcurrentHashMap<String, EvictedRelay>();
        for (Map.Entry<String, EvictedRelay> entry : this.evictedRelays.entrySet()) {
            EvictedRelay evicted = entry.getValue();
            if (evicted.retryCount() >= this.maxRetryCount) {
                LOGGER.debug("relay_re_evaluator retry_skipped url={} reason=max_retries_exceeded retry_count={}", (Object)evicted.relayUrl(), (Object)evicted.retryCount());
                continue;
            }
            if (!evicted.isEligibleForRetry(this.retryInterval)) continue;
            eligible.put(entry.getKey(), evicted);
            LOGGER.debug("relay_re_evaluator retry_eligible url={} retry_count={} evicted_at={}", evicted.relayUrl(), evicted.retryCount(), evicted.evictedAt());
        }
        if (!eligible.isEmpty()) {
            LOGGER.info("relay_re_evaluator retry_batch_identified count={}", (Object)eligible.size());
        }
        return eligible;
    }

    public void recordRetryAttempt(String relayUrl) {
        Objects.requireNonNull(relayUrl, "relayUrl");
        this.evictedRelays.compute(relayUrl, (url, current) -> {
            if (current == null) {
                LOGGER.warn("relay_re_evaluator retry_recorded url={} reason=not_evicted impact=ignored", (Object)relayUrl);
                return null;
            }
            EvictedRelay updated = current.withRetry();
            LOGGER.debug("relay_re_evaluator retry_recorded url={} retry_count={}", (Object)relayUrl, (Object)updated.retryCount());
            return updated;
        });
    }

    public boolean promoteRelay(String relayUrl) {
        Objects.requireNonNull(relayUrl, "relayUrl");
        EvictedRelay removed = this.evictedRelays.remove(relayUrl);
        if (removed != null) {
            LOGGER.info("relay_re_evaluator relay_promoted url={} retry_count={} outcome=returned_to_active", (Object)relayUrl, (Object)removed.retryCount());
            return true;
        }
        return false;
    }

    public boolean abandonRelay(String relayUrl) {
        Objects.requireNonNull(relayUrl, "relayUrl");
        EvictedRelay removed = this.evictedRelays.remove(relayUrl);
        if (removed != null) {
            LOGGER.warn("relay_re_evaluator relay_abandoned url={} retry_count={} outcome=permanently_removed", (Object)relayUrl, (Object)removed.retryCount());
            return true;
        }
        return false;
    }

    public boolean isEvicted(String relayUrl) {
        Objects.requireNonNull(relayUrl, "relayUrl");
        return this.evictedRelays.containsKey(relayUrl);
    }

    public EvictedRelay getEvictionRecord(String relayUrl) {
        Objects.requireNonNull(relayUrl, "relayUrl");
        return this.evictedRelays.get(relayUrl);
    }

    public int getEvictedCount() {
        return this.evictedRelays.size();
    }

    public int performReEvaluation(Consumer<String> retryHandler) {
        Objects.requireNonNull(retryHandler, "retryHandler");
        Map<String, EvictedRelay> eligible = this.getEligibleForRetry();
        if (eligible.isEmpty()) {
            return 0;
        }
        LOGGER.info("relay_re_evaluator re_evaluation_started relay_count={}", (Object)eligible.size());
        for (String relayUrl : eligible.keySet()) {
            this.recordRetryAttempt(relayUrl);
            try {
                retryHandler.accept(relayUrl);
            }
            catch (Exception e) {
                LOGGER.error("relay_re_evaluator retry_failed url={} reason={} impact=will_retry_later", relayUrl, e.getMessage(), e);
            }
        }
        LOGGER.info("relay_re_evaluator re_evaluation_completed attempted={}", (Object)eligible.size());
        return eligible.size();
    }

    public Duration getRetryInterval() {
        return this.retryInterval;
    }

    public int getMaxRetryCount() {
        return this.maxRetryCount;
    }

    public Map<String, EvictedRelay> getAllEvictedRelays() {
        return Map.copyOf(this.evictedRelays);
    }

    public void restoreEvictedRelays(Map<String, EvictedRelay> evictedMap) {
        Objects.requireNonNull(evictedMap, "evictedMap");
        this.evictedRelays.putAll(evictedMap);
        LOGGER.info("relay_re_evaluator evicted_restored count={}", (Object)evictedMap.size());
    }
}

