/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.relay;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import xyz.tcheeric.wallet.core.nostr.relay.RelayConnection;
import xyz.tcheeric.wallet.core.nostr.relay.RelaySelectionPolicy;

public class RelaySet {
    private final List<RelayConnection> writeRelays;
    private final List<RelayConnection> readRelays;
    private final List<RelayConnection> allRelays;

    public RelaySet(Collection<RelayConnection> writeRelays, Collection<RelayConnection> readRelays) {
        Objects.requireNonNull(writeRelays, "writeRelays");
        Objects.requireNonNull(readRelays, "readRelays");
        this.writeRelays = List.copyOf(writeRelays);
        this.readRelays = List.copyOf(readRelays);
        Set seen = this.writeRelays.stream().map(RelayConnection::url).collect(Collectors.toSet());
        ArrayList<RelayConnection> combined = new ArrayList<RelayConnection>(this.writeRelays);
        this.readRelays.stream().filter(relay -> !seen.contains(relay.url())).forEach(combined::add);
        this.allRelays = List.copyOf(combined);
    }

    public RelaySet(Collection<RelayConnection> relays) {
        this(relays, relays);
    }

    public List<RelayConnection> writeRelays() {
        return this.writeRelays;
    }

    public List<RelayConnection> readRelays() {
        return this.readRelays;
    }

    public List<RelayConnection> allRelays() {
        return this.allRelays;
    }

    public List<RelayConnection> getRelaysFor(RelaySelectionPolicy.OperationType operationType) {
        Objects.requireNonNull(operationType, "operationType");
        return operationType == RelaySelectionPolicy.OperationType.PUBLISH ? this.writeRelays : this.readRelays;
    }

    public int totalRelayCount() {
        return this.allRelays.size();
    }

    public boolean isSegregated() {
        return !this.writeRelays.equals(this.readRelays);
    }

    public RelaySet withUpdatedStatuses(Collection<RelayConnection> updatedRelays) {
        Objects.requireNonNull(updatedRelays, "updatedRelays");
        Map<String, RelayConnection> statusMap = updatedRelays.stream().collect(Collectors.toMap(RelayConnection::url, relay -> relay, (r1, r2) -> r2));
        List<RelayConnection> updatedWrite = this.writeRelays.stream().map(relay -> statusMap.getOrDefault(relay.url(), (RelayConnection)relay)).toList();
        List<RelayConnection> updatedRead = this.readRelays.stream().map(relay -> statusMap.getOrDefault(relay.url(), (RelayConnection)relay)).toList();
        return new RelaySet(updatedWrite, updatedRead);
    }

    public String toString() {
        if (this.isSegregated()) {
            return String.format("RelaySet[write=%d, read=%d, total=%d]", this.writeRelays.size(), this.readRelays.size(), this.totalRelayCount());
        }
        return String.format("RelaySet[unified=%d]", this.totalRelayCount());
    }
}

