/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.relay;

import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import xyz.tcheeric.wallet.core.nostr.relay.RelayStatus;

public record RelayTelemetry(int totalRelays, int connectedRelays, int degradedRelays, int disconnectedRelays, int evictedRelays, double averageHealthScore, Double averageLatencyMs, long totalOperations, long totalFailures, double overallSuccessRate, Instant capturedAt) {
    public RelayTelemetry {
        Objects.requireNonNull(capturedAt, "capturedAt");
        if (totalRelays < 0) {
            throw new IllegalArgumentException("totalRelays cannot be negative");
        }
        if (averageHealthScore < 0.0 || averageHealthScore > 100.0) {
            throw new IllegalArgumentException("averageHealthScore must be between 0 and 100");
        }
        if (overallSuccessRate < 0.0 || overallSuccessRate > 1.0) {
            throw new IllegalArgumentException("overallSuccessRate must be between 0 and 1");
        }
    }

    public static RelayTelemetry empty() {
        return new RelayTelemetry(0, 0, 0, 0, 0, 0.0, null, 0L, 0L, 0.0, Instant.now());
    }

    public String toLogString() {
        return String.format("relay_telemetry total=%d connected=%d degraded=%d disconnected=%d evicted=%d avg_health=%.1f avg_latency_ms=%s total_ops=%d failures=%d success_rate=%.3f", this.totalRelays, this.connectedRelays, this.degradedRelays, this.disconnectedRelays, this.evictedRelays, this.averageHealthScore, this.averageLatencyMs != null ? String.format("%.1f", this.averageLatencyMs) : "N/A", this.totalOperations, this.totalFailures, this.overallSuccessRate);
    }

    public Map<RelayStatus, Double> getHealthDistribution() {
        if (this.totalRelays == 0) {
            return Map.of();
        }
        return Map.of(RelayStatus.CONNECTED, (double)this.connectedRelays / (double)this.totalRelays, RelayStatus.DEGRADED, (double)this.degradedRelays / (double)this.totalRelays, RelayStatus.DISCONNECTED, (double)this.disconnectedRelays / (double)this.totalRelays);
    }

    public boolean isHealthy() {
        if (this.totalRelays == 0) {
            return false;
        }
        double disconnectedRatio = (double)this.disconnectedRelays / (double)this.totalRelays;
        return this.connectedRelays > 0 && disconnectedRatio < 0.5 && this.overallSuccessRate >= 0.8;
    }
}

