/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.voucher;

import java.time.Instant;
import lombok.NonNull;
import org.bouncycastle.util.encoders.Hex;
import xyz.tcheeric.cashu.voucher.domain.SignedVoucher;
import xyz.tcheeric.cashu.voucher.domain.VoucherSecret;
import xyz.tcheeric.wallet.core.state.StoredVoucher;

public final class VoucherConverter {
    private VoucherConverter() {
        throw new UnsupportedOperationException("Utility class cannot be instantiated");
    }

    public static SignedVoucher toSignedVoucher(@NonNull StoredVoucher stored) {
        if (stored == null) {
            throw new NullPointerException("stored is marked non-null but is null");
        }
        try {
            VoucherSecret secret = VoucherSecret.create(stored.voucherId(), stored.issuerId(), stored.unit(), stored.faceValue(), stored.expiresAt(), stored.memo());
            byte[] signatureBytes = Hex.decode(stored.issuerSignature());
            return new SignedVoucher(secret, signatureBytes, stored.issuerPublicKey());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to convert StoredVoucher to SignedVoucher: " + e.getMessage(), e);
        }
    }

    public static StoredVoucher toStoredVoucher(@NonNull SignedVoucher signed, @NonNull String status, @NonNull Instant issuedAt) {
        if (signed == null) {
            throw new NullPointerException("signed is marked non-null but is null");
        }
        if (status == null) {
            throw new NullPointerException("status is marked non-null but is null");
        }
        if (issuedAt == null) {
            throw new NullPointerException("issuedAt is marked non-null but is null");
        }
        try {
            VoucherSecret secret = signed.getSecret();
            String signatureHex = Hex.toHexString(signed.getIssuerSignature());
            return new StoredVoucher(secret.getVoucherId(), secret.getIssuerId(), secret.getUnit(), secret.getFaceValue(), secret.getExpiresAt(), secret.getMemo(), signatureHex, signed.getIssuerPublicKey(), issuedAt, status);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to convert SignedVoucher to StoredVoucher: " + e.getMessage(), e);
        }
    }

    public static StoredVoucher toStoredVoucher(@NonNull SignedVoucher signed) {
        if (signed == null) {
            throw new NullPointerException("signed is marked non-null but is null");
        }
        return VoucherConverter.toStoredVoucher(signed, "issued", Instant.now());
    }
}

