/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.voucher;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.PublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.voucher.app.ports.VoucherLedgerPort;
import xyz.tcheeric.cashu.voucher.domain.SignedVoucher;
import xyz.tcheeric.cashu.voucher.domain.VoucherStatus;
import xyz.tcheeric.cashu.voucher.nostr.NostrVoucherLedgerRepository;
import xyz.tcheeric.wallet.core.nostr.NostrGatewayService;
import xyz.tcheeric.wallet.core.nostr.voucher.VoucherConverter;
import xyz.tcheeric.wallet.core.nostr.voucher.WalletNostrClientAdapter;
import xyz.tcheeric.wallet.core.security.IdentityKey;
import xyz.tcheeric.wallet.core.security.IdentityKeyService;
import xyz.tcheeric.wallet.core.state.StoredVoucher;

public class VoucherLedgerAdapter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VoucherLedgerAdapter.class);
    private final NostrGatewayService nostrGateway;
    private final IdentityKeyService identityKeyService;
    private final VoucherLedgerPort ledgerPort;

    public VoucherLedgerAdapter(@NonNull NostrGatewayService nostrGateway, @NonNull IdentityKeyService identityKeyService) {
        this.nostrGateway = Objects.requireNonNull(nostrGateway, "nostrGateway");
        this.identityKeyService = Objects.requireNonNull(identityKeyService, "identityKeyService");
        WalletNostrClientAdapter nostrClientAdapter = new WalletNostrClientAdapter(nostrGateway);
        IdentityKey identity = identityKeyService.loadOrCreate();
        PublicKey issuerPublicKey = new PublicKey(identity.publicKeyEncoded());
        this.ledgerPort = new NostrVoucherLedgerRepository(nostrClientAdapter, issuerPublicKey);
        log.info("VoucherLedgerAdapter initialized: issuerPubkey={}", (Object)identity.publicKeyHex());
    }

    public void publishVoucher(@NonNull StoredVoucher voucher, @NonNull VoucherStatus status) {
        if (voucher == null) {
            throw new NullPointerException("voucher is marked non-null but is null");
        }
        if (status == null) {
            throw new NullPointerException("status is marked non-null but is null");
        }
        log.info("voucher_ledger publishing_voucher voucher_id={} status={}", (Object)voucher.voucherId(), (Object)status);
        try {
            SignedVoucher signedVoucher = VoucherConverter.toSignedVoucher(voucher);
            this.ledgerPort.publish(signedVoucher, status);
            log.info("voucher_ledger publish_success voucher_id={} status={}", (Object)voucher.voucherId(), (Object)status);
        }
        catch (Exception e) {
            log.error("voucher_ledger publish_failed voucher_id={} status={} error={}", new Object[]{voucher.voucherId(), status, e.getMessage(), e});
            throw new RuntimeException("Failed to publish voucher to ledger: " + e.getMessage(), e);
        }
    }

    public Optional<VoucherStatus> queryStatus(@NonNull String voucherId) {
        if (voucherId == null) {
            throw new NullPointerException("voucherId is marked non-null but is null");
        }
        log.debug("voucher_ledger querying_status voucher_id={}", (Object)voucherId);
        try {
            Optional<VoucherStatus> status = this.ledgerPort.queryStatus(voucherId);
            log.debug("voucher_ledger query_complete voucher_id={} status={}", (Object)voucherId, (Object)status.map(Enum::name).orElse("NOT_FOUND"));
            return status;
        }
        catch (Exception e) {
            log.error("voucher_ledger query_failed voucher_id={} error={}", voucherId, e.getMessage(), e);
            throw new RuntimeException("Failed to query voucher status: " + e.getMessage(), e);
        }
    }

    public void updateStatus(@NonNull String voucherId, @NonNull VoucherStatus newStatus) {
        if (voucherId == null) {
            throw new NullPointerException("voucherId is marked non-null but is null");
        }
        if (newStatus == null) {
            throw new NullPointerException("newStatus is marked non-null but is null");
        }
        log.info("voucher_ledger updating_status voucher_id={} new_status={}", (Object)voucherId, (Object)newStatus);
        try {
            this.ledgerPort.updateStatus(voucherId, newStatus);
            log.info("voucher_ledger update_success voucher_id={} new_status={}", (Object)voucherId, (Object)newStatus);
        }
        catch (Exception e) {
            log.error("voucher_ledger update_failed voucher_id={} new_status={} error={}", new Object[]{voucherId, newStatus, e.getMessage(), e});
            throw new RuntimeException("Failed to update voucher status: " + e.getMessage(), e);
        }
    }

    public boolean exists(@NonNull String voucherId) {
        if (voucherId == null) {
            throw new NullPointerException("voucherId is marked non-null but is null");
        }
        log.debug("voucher_ledger checking_exists voucher_id={}", (Object)voucherId);
        boolean exists = this.ledgerPort.exists(voucherId);
        log.debug("voucher_ledger exists_result voucher_id={} exists={}", (Object)voucherId, (Object)exists);
        return exists;
    }

    public Optional<StoredVoucher> queryVoucher(@NonNull String voucherId) {
        if (voucherId == null) {
            throw new NullPointerException("voucherId is marked non-null but is null");
        }
        log.debug("voucher_ledger querying_voucher voucher_id={}", (Object)voucherId);
        try {
            Optional<SignedVoucher> signedVoucher = this.ledgerPort.queryVoucher(voucherId);
            if (signedVoucher.isEmpty()) {
                log.debug("voucher_ledger voucher_not_found voucher_id={}", (Object)voucherId);
                return Optional.empty();
            }
            Optional<VoucherStatus> status = this.ledgerPort.queryStatus(voucherId);
            String statusStr = status.map(Enum::name).map(String::toLowerCase).orElse("issued");
            StoredVoucher stored = VoucherConverter.toStoredVoucher(signedVoucher.get(), statusStr, Instant.now());
            log.debug("voucher_ledger query_voucher_success voucher_id={}", (Object)voucherId);
            return Optional.of(stored);
        }
        catch (Exception e) {
            log.error("voucher_ledger query_voucher_failed voucher_id={} error={}", voucherId, e.getMessage(), e);
            throw new RuntimeException("Failed to query voucher: " + e.getMessage(), e);
        }
    }

    public VoucherLedgerPort getLedgerPort() {
        return this.ledgerPort;
    }
}

