/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.observability;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Resilience4jMetrics {
    private static final Logger log = LoggerFactory.getLogger(Resilience4jMetrics.class);
    private final MeterRegistry registry;
    private final Map<String, CircuitBreaker> registeredBreakers = new ConcurrentHashMap<String, CircuitBreaker>();

    public Resilience4jMetrics(MeterRegistry registry) {
        this.registry = registry;
    }

    public void registerCircuitBreaker(String name, CircuitBreaker circuitBreaker) {
        if (this.registeredBreakers.containsKey(name)) {
            log.debug("Circuit breaker {} already registered", (Object)name);
            return;
        }
        log.info("Registering circuit breaker metrics for: {}", (Object)name);
        this.registeredBreakers.put(name, circuitBreaker);
        Tags tags = Tags.of(Tag.of("name", name), Tag.of("application", "cashu-wallet"));
        Gauge.builder("resilience4j.circuitbreaker.state", circuitBreaker, cb -> switch (cb.getState()) {
            default -> throw new MatchException(null, null);
            case CircuitBreaker.State.CLOSED -> 0.0;
            case CircuitBreaker.State.OPEN -> 1.0;
            case CircuitBreaker.State.HALF_OPEN -> 2.0;
            case CircuitBreaker.State.DISABLED -> 3.0;
            case CircuitBreaker.State.FORCED_OPEN -> 4.0;
            case CircuitBreaker.State.METRICS_ONLY -> 5.0;
        }).description("Circuit breaker state").tags(tags).register(this.registry);
        Gauge.builder("resilience4j.circuitbreaker.failure.rate", circuitBreaker, cb -> cb.getMetrics().getFailureRate()).description("Circuit breaker failure rate percentage").tags(tags).register(this.registry);
        Gauge.builder("resilience4j.circuitbreaker.slow.call.rate", circuitBreaker, cb -> cb.getMetrics().getSlowCallRate()).description("Circuit breaker slow call rate percentage").tags(tags).register(this.registry);
        Gauge.builder("resilience4j.circuitbreaker.buffered.calls", circuitBreaker, cb -> cb.getMetrics().getNumberOfBufferedCalls()).description("Circuit breaker buffered calls").tags(tags).register(this.registry);
        Gauge.builder("resilience4j.circuitbreaker.successful.calls", circuitBreaker, cb -> cb.getMetrics().getNumberOfSuccessfulCalls()).description("Circuit breaker successful calls").tags(tags).register(this.registry);
        Gauge.builder("resilience4j.circuitbreaker.failed.calls", circuitBreaker, cb -> cb.getMetrics().getNumberOfFailedCalls()).description("Circuit breaker failed calls").tags(tags).register(this.registry);
        Gauge.builder("resilience4j.circuitbreaker.slow.calls", circuitBreaker, cb -> cb.getMetrics().getNumberOfSlowCalls()).description("Circuit breaker slow calls").tags(tags).register(this.registry);
        Gauge.builder("resilience4j.circuitbreaker.slow.successful.calls", circuitBreaker, cb -> cb.getMetrics().getNumberOfSlowSuccessfulCalls()).description("Circuit breaker slow successful calls").tags(tags).register(this.registry);
        Gauge.builder("resilience4j.circuitbreaker.slow.failed.calls", circuitBreaker, cb -> cb.getMetrics().getNumberOfSlowFailedCalls()).description("Circuit breaker slow failed calls").tags(tags).register(this.registry);
        Gauge.builder("resilience4j.circuitbreaker.not.permitted.calls", circuitBreaker, cb -> cb.getMetrics().getNumberOfNotPermittedCalls()).description("Circuit breaker not permitted calls").tags(tags).register(this.registry);
    }

    public void unregisterCircuitBreaker(String name) {
        CircuitBreaker removed = this.registeredBreakers.remove(name);
        if (removed != null) {
            log.info("Unregistered circuit breaker metrics for: {}", (Object)name);
        }
    }

    public Set<String> getRegisteredNames() {
        return Collections.unmodifiableSet(this.registeredBreakers.keySet());
    }
}

