/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.observability;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.prometheusmetrics.PrometheusConfig;
import io.micrometer.prometheusmetrics.PrometheusMeterRegistry;
import io.undertow.Undertow;
import io.undertow.util.Headers;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.wallet.core.observability.spi.MetricsExtension;

public class WalletMetrics
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(WalletMetrics.class);
    private static final int DEFAULT_METRICS_PORT = 9090;
    private static final String METRICS_PATH = "/metrics";
    private static WalletMetrics INSTANCE;
    private final PrometheusMeterRegistry registry;
    private final Undertow httpServer;
    private final boolean enabled;
    private final Counter paymentTotal;
    private final Counter paymentSuccess;
    private final Counter paymentFailure;
    private final Counter proofImported;
    private final Counter proofSpent;
    private final Counter relayPublishTotal;
    private final Counter relayPublishSuccess;
    private final Counter relayPublishFailure;
    private final Counter cashuSnapshotPublishSuccess;
    private final Counter cashuSnapshotPublishFailure;
    private final Counter cashuSnapshotReceived;
    private final Counter cashuHistoryPublishSuccess;
    private final Counter cashuHistoryPublishFailure;
    private final Counter cashuHistoryReceived;
    private final Timer paymentTimer;
    private final Timer proofImportTimer;
    private final Timer relayPublishTimer;
    private final AtomicLong pendingProofs = new AtomicLong(0L);
    private final AtomicLong currentBalance = new AtomicLong(0L);
    private final AtomicLong connectedRelays = new AtomicLong(0L);

    private WalletMetrics(PrometheusMeterRegistry registry, Undertow httpServer, boolean enabled) {
        this.registry = registry;
        this.httpServer = httpServer;
        this.enabled = enabled;
        this.paymentTotal = Counter.builder("wallet.payment.total").description("Total payment attempts").tag("application", "cashu-wallet").register(registry);
        this.paymentSuccess = Counter.builder("wallet.payment.success").description("Successful payments").tag("application", "cashu-wallet").register(registry);
        this.paymentFailure = Counter.builder("wallet.payment.failure").description("Failed payments").tag("application", "cashu-wallet").register(registry);
        this.proofImported = Counter.builder("wallet.proof.imported").description("Proofs imported").tag("application", "cashu-wallet").register(registry);
        this.proofSpent = Counter.builder("wallet.proof.spent").description("Proofs spent").tag("application", "cashu-wallet").register(registry);
        this.relayPublishTotal = Counter.builder("nostr.relay.publish.total").description("Total relay publish attempts").tag("application", "cashu-wallet").register(registry);
        this.relayPublishSuccess = Counter.builder("nostr.relay.publish.success").description("Successful relay publishes").tag("application", "cashu-wallet").register(registry);
        this.relayPublishFailure = Counter.builder("nostr.relay.publish.failure").description("Failed relay publishes").tag("application", "cashu-wallet").register(registry);
        this.cashuSnapshotPublishSuccess = Counter.builder("nostr.cashu.snapshot.publish.success").description("Published NIP-60 snapshots successfully").tag("application", "cashu-wallet").register(registry);
        this.cashuSnapshotPublishFailure = Counter.builder("nostr.cashu.snapshot.publish.failure").description("Failed NIP-60 snapshot publishes").tag("application", "cashu-wallet").register(registry);
        this.cashuSnapshotReceived = Counter.builder("nostr.cashu.snapshot.received").description("Received NIP-60 snapshots").tag("application", "cashu-wallet").register(registry);
        this.cashuHistoryPublishSuccess = Counter.builder("nostr.cashu.history.publish.success").description("Published NIP-61 history successfully").tag("application", "cashu-wallet").register(registry);
        this.cashuHistoryPublishFailure = Counter.builder("nostr.cashu.history.publish.failure").description("Failed NIP-61 history publishes").tag("application", "cashu-wallet").register(registry);
        this.cashuHistoryReceived = Counter.builder("nostr.cashu.history.received").description("Received NIP-61 history").tag("application", "cashu-wallet").register(registry);
        this.paymentTimer = Timer.builder("wallet.payment.duration").description("Payment duration in milliseconds").tag("application", "cashu-wallet").register(registry);
        this.proofImportTimer = Timer.builder("wallet.proof.import.duration").description("Proof import duration in milliseconds").tag("application", "cashu-wallet").register(registry);
        this.relayPublishTimer = Timer.builder("nostr.relay.publish.duration").description("Relay publish duration in milliseconds").tag("application", "cashu-wallet").register(registry);
        Gauge.builder("wallet.proof.pending", this.pendingProofs, AtomicLong::get).description("Number of pending proofs").tag("application", "cashu-wallet").register(registry);
        Gauge.builder("wallet.balance.sats", this.currentBalance, AtomicLong::get).description("Current wallet balance in satoshis").tag("application", "cashu-wallet").register(registry);
        Gauge.builder("nostr.relay.connected", this.connectedRelays, AtomicLong::get).description("Number of connected Nostr relays").tag("application", "cashu-wallet").register(registry);
    }

    public static synchronized WalletMetrics initialize() {
        if (INSTANCE == null) {
            INSTANCE = WalletMetrics.create();
        }
        return INSTANCE;
    }

    static synchronized void resetForTests() {
        if (INSTANCE != null) {
            try {
                INSTANCE.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            INSTANCE = null;
        }
    }

    public static synchronized WalletMetrics getInstance() {
        if (INSTANCE == null) {
            log.warn("WalletMetrics not initialized, returning no-op instance");
            return WalletMetrics.createNoOp();
        }
        return INSTANCE;
    }

    private static void loadMetricsExtensions(MeterRegistry registry) {
        ServiceLoader<MetricsExtension> loader = ServiceLoader.load(MetricsExtension.class);
        ArrayList<MetricsExtension> extensions = new ArrayList<MetricsExtension>();
        for (MetricsExtension extension : loader) {
            extensions.add(extension);
            log.debug("metrics_extension_discovered name={} priority={}", (Object)extension.getName(), (Object)extension.getPriority());
        }
        if (extensions.isEmpty()) {
            log.debug("No MetricsExtension implementations found via ServiceLoader");
            return;
        }
        extensions.sort(Comparator.comparingInt(MetricsExtension::getPriority));
        for (MetricsExtension extension : extensions) {
            try {
                log.info("metrics_extension_initializing name={} priority={}", (Object)extension.getName(), (Object)extension.getPriority());
                extension.registerMetrics(registry);
                log.info("metrics_extension_initialized name={} priority={}", (Object)extension.getName(), (Object)extension.getPriority());
            }
            catch (Exception e) {
                log.error("metrics_extension_failed name={} error={}", extension.getName(), e.getMessage(), e);
            }
        }
    }

    private static WalletMetrics create() {
        boolean enabled = Boolean.parseBoolean(System.getProperty("WALLET_METRICS_ENABLED", System.getenv().getOrDefault("WALLET_METRICS_ENABLED", "false")));
        if (!enabled) {
            log.info("Metrics disabled (WALLET_METRICS_ENABLED=false)");
            return WalletMetrics.createNoOp();
        }
        int port = Integer.parseInt(System.getProperty("WALLET_METRICS_PORT", System.getenv().getOrDefault("WALLET_METRICS_PORT", String.valueOf(9090))));
        log.info("Initializing Micrometer metrics with Prometheus registry on port {}", (Object)port);
        PrometheusMeterRegistry registry = new PrometheusMeterRegistry(PrometheusConfig.DEFAULT);
        new ClassLoaderMetrics().bindTo(registry);
        new JvmMemoryMetrics().bindTo(registry);
        new JvmGcMetrics().bindTo(registry);
        new JvmThreadMetrics().bindTo(registry);
        new ProcessorMetrics().bindTo(registry);
        WalletMetrics.loadMetricsExtensions(registry);
        Undertow httpServer = null;
        try {
            httpServer = Undertow.builder().addHttpListener(port, "0.0.0.0").setHandler(exchange2 -> {
                if (!METRICS_PATH.equals(exchange2.getRequestPath())) {
                    exchange2.setStatusCode(404);
                    exchange2.getResponseSender().send("Not Found", StandardCharsets.UTF_8);
                    return;
                }
                if (!"GET".equalsIgnoreCase(exchange2.getRequestMethod().toString())) {
                    exchange2.setStatusCode(405);
                    exchange2.getResponseHeaders().put(Headers.ALLOW, "GET");
                    exchange2.getResponseSender().send("Method Not Allowed", StandardCharsets.UTF_8);
                    return;
                }
                String response = registry.scrape();
                exchange2.getResponseHeaders().put(Headers.CONTENT_TYPE, "text/plain; version=0.0.4; charset=utf-8");
                exchange2.getResponseSender().send(response, StandardCharsets.UTF_8);
            }).build();
            httpServer.start();
            log.info("Prometheus metrics endpoint started at http://localhost:{}{}", (Object)port, (Object)METRICS_PATH);
        }
        catch (RuntimeException e) {
            log.error("Failed to start metrics HTTP server on port {}", (Object)port, (Object)e);
        }
        return new WalletMetrics(registry, httpServer, true);
    }

    private static WalletMetrics createNoOp() {
        PrometheusMeterRegistry noopRegistry = new PrometheusMeterRegistry(PrometheusConfig.DEFAULT);
        return new WalletMetrics(noopRegistry, null, false);
    }

    public MeterRegistry getRegistry() {
        return this.registry;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String scrape() {
        return this.registry.scrape();
    }

    public void recordPaymentAttempt(String mintUrl) {
        this.paymentTotal.increment();
    }

    public void recordPaymentSuccess(String mintUrl) {
        this.paymentSuccess.increment();
    }

    public void recordPaymentFailure(String mintUrl, String reason) {
        this.paymentFailure.increment();
    }

    public Timer getPaymentTimer() {
        return this.paymentTimer;
    }

    public void recordProofImported(int count) {
        this.proofImported.increment(count);
    }

    public void recordProofSpent(int count) {
        this.proofSpent.increment(count);
    }

    public void updatePendingProofs(long count) {
        this.pendingProofs.set(count);
    }

    public Timer getProofImportTimer() {
        return this.proofImportTimer;
    }

    public void updateBalance(long sats) {
        this.currentBalance.set(sats);
    }

    public void recordRelayPublishAttempt(String relayUrl) {
        this.relayPublishTotal.increment();
    }

    public void recordRelayPublishSuccess(String relayUrl) {
        this.relayPublishSuccess.increment();
    }

    public void recordRelayPublishFailure(String relayUrl, String reason) {
        this.relayPublishFailure.increment();
    }

    public void updateConnectedRelays(long count) {
        this.connectedRelays.set(count);
    }

    public Timer getRelayPublishTimer() {
        return this.relayPublishTimer;
    }

    public void recordSnapshotPublishSuccess() {
        this.cashuSnapshotPublishSuccess.increment();
    }

    public void recordSnapshotPublishFailure() {
        this.cashuSnapshotPublishFailure.increment();
    }

    public void recordSnapshotReceived() {
        this.cashuSnapshotReceived.increment();
    }

    public void recordHistoryPublishSuccess() {
        this.cashuHistoryPublishSuccess.increment();
    }

    public void recordHistoryPublishFailure() {
        this.cashuHistoryPublishFailure.increment();
    }

    public void recordHistoryReceived() {
        this.cashuHistoryReceived.increment();
    }

    @Override
    public void close() {
        if (this.httpServer != null) {
            log.info("Shutting down metrics HTTP server");
            this.httpServer.stop();
        }
        if (this.registry != null) {
            this.registry.close();
        }
    }
}

