/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.observability;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WalletTracing
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(WalletTracing.class);
    private static final String DEFAULT_SERVICE_NAME = "cashu-wallet";
    private static final String DEFAULT_SERVICE_VERSION = "0.3.0-M3";
    private static final String DEFAULT_OTLP_ENDPOINT = "http://localhost:4317";
    private static WalletTracing INSTANCE;
    private final OpenTelemetry openTelemetry;
    private final SdkTracerProvider sdkTracerProvider;
    private final Tracer tracer;
    private final boolean enabled;

    private WalletTracing(OpenTelemetry openTelemetry, SdkTracerProvider sdkTracerProvider, Tracer tracer, boolean enabled) {
        this.openTelemetry = openTelemetry;
        this.sdkTracerProvider = sdkTracerProvider;
        this.tracer = tracer;
        this.enabled = enabled;
    }

    public static synchronized WalletTracing initialize() {
        if (INSTANCE == null) {
            INSTANCE = WalletTracing.create();
        }
        return INSTANCE;
    }

    public static synchronized WalletTracing getInstance() {
        if (INSTANCE == null) {
            log.warn("WalletTracing not initialized, returning no-op instance");
            return WalletTracing.createNoOp();
        }
        return INSTANCE;
    }

    private static WalletTracing create() {
        boolean enabled = Boolean.parseBoolean(System.getProperty("WALLET_TRACING_ENABLED", System.getenv().getOrDefault("WALLET_TRACING_ENABLED", "false")));
        if (!enabled) {
            log.info("Tracing disabled (WALLET_TRACING_ENABLED=false)");
            return WalletTracing.createNoOp();
        }
        String serviceName = System.getProperty("OTEL_SERVICE_NAME", System.getenv().getOrDefault("OTEL_SERVICE_NAME", DEFAULT_SERVICE_NAME));
        String serviceVersion = System.getProperty("OTEL_SERVICE_VERSION", System.getenv().getOrDefault("OTEL_SERVICE_VERSION", DEFAULT_SERVICE_VERSION));
        String otlpEndpoint = System.getProperty("OTEL_EXPORTER_OTLP_ENDPOINT", System.getenv().getOrDefault("OTEL_EXPORTER_OTLP_ENDPOINT", DEFAULT_OTLP_ENDPOINT));
        log.info("Initializing OpenTelemetry tracing: service={}, version={}, endpoint={}", serviceName, serviceVersion, otlpEndpoint);
        Resource resource = Resource.getDefault().merge(Resource.create(Attributes.builder().put(ResourceAttributes.SERVICE_NAME, serviceName).put(ResourceAttributes.SERVICE_VERSION, serviceVersion).put(ResourceAttributes.DEPLOYMENT_ENVIRONMENT, System.getenv().getOrDefault("OTEL_DEPLOYMENT_ENVIRONMENT", "development")).build()));
        OtlpGrpcSpanExporter spanExporter = OtlpGrpcSpanExporter.builder().setEndpoint(otlpEndpoint).setTimeout(Duration.ofSeconds(10L)).setCompression("gzip").build();
        BatchSpanProcessor batchSpanProcessor = BatchSpanProcessor.builder(spanExporter).setScheduleDelay(Duration.ofSeconds(5L)).setMaxQueueSize(2048).setMaxExportBatchSize(512).setExporterTimeout(Duration.ofSeconds(30L)).build();
        Sampler sampler = WalletTracing.configureSampler();
        SdkTracerProvider sdkTracerProvider = SdkTracerProvider.builder().setResource(resource).addSpanProcessor(batchSpanProcessor).setSampler(sampler).build();
        OpenTelemetrySdk openTelemetrySdk = OpenTelemetrySdk.builder().setTracerProvider(sdkTracerProvider).setPropagators(ContextPropagators.create(W3CTraceContextPropagator.getInstance())).buildAndRegisterGlobal();
        Tracer tracer = openTelemetrySdk.getTracer("xyz.tcheeric.wallet", serviceVersion);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            log.info("Shutting down OpenTelemetry tracing");
            sdkTracerProvider.shutdown().join(10L, TimeUnit.SECONDS);
        }));
        log.info("OpenTelemetry tracing initialized successfully");
        return new WalletTracing(openTelemetrySdk, sdkTracerProvider, tracer, true);
    }

    private static Sampler configureSampler() {
        String samplerType;
        return switch (samplerType = System.getProperty("OTEL_TRACES_SAMPLER", System.getenv().getOrDefault("OTEL_TRACES_SAMPLER", "parentbased_always_on"))) {
            case "always_on" -> Sampler.alwaysOn();
            case "always_off" -> Sampler.alwaysOff();
            case "traceidratio" -> {
                double ratio = Double.parseDouble(System.getProperty("OTEL_TRACES_SAMPLER_ARG", System.getenv().getOrDefault("OTEL_TRACES_SAMPLER_ARG", "0.1")));
                yield Sampler.traceIdRatioBased(ratio);
            }
            case "parentbased_traceidratio" -> {
                double ratio = Double.parseDouble(System.getProperty("OTEL_TRACES_SAMPLER_ARG", System.getenv().getOrDefault("OTEL_TRACES_SAMPLER_ARG", "0.1")));
                yield Sampler.parentBased(Sampler.traceIdRatioBased(ratio));
            }
            default -> Sampler.parentBasedBuilder(Sampler.alwaysOn()).build();
        };
    }

    private static WalletTracing createNoOp() {
        OpenTelemetry noopOpenTelemetry = OpenTelemetry.noop();
        Tracer noopTracer = noopOpenTelemetry.getTracer("xyz.tcheeric.wallet");
        return new WalletTracing(noopOpenTelemetry, null, noopTracer, false);
    }

    public static synchronized void resetForTests() {
        if (INSTANCE != null) {
            try {
                INSTANCE.close();
            }
            finally {
                INSTANCE = null;
            }
        } else {
            INSTANCE = null;
        }
        try {
            GlobalOpenTelemetry.resetForTest();
        }
        catch (UnsupportedOperationException ignored) {
            log.debug("GlobalOpenTelemetry reset not supported in current runtime");
        }
    }

    public OpenTelemetry getOpenTelemetry() {
        return this.openTelemetry;
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void close() {
        if (this.sdkTracerProvider != null) {
            log.info("Closing WalletTracing");
            this.sdkTracerProvider.shutdown().join(10L, TimeUnit.SECONDS);
        }
    }

    public void forceFlush() {
        if (this.sdkTracerProvider != null) {
            log.debug("Force flushing spans");
            this.sdkTracerProvider.forceFlush().join(10L, TimeUnit.SECONDS);
        }
    }
}

