/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.security;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.wallet.core.security.SecureKeyStore;

class FileSystemSecureKeyStore
implements SecureKeyStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemSecureKeyStore.class);
    private final Path walletHome;

    FileSystemSecureKeyStore(Path walletHome) {
        this.walletHome = walletHome;
        LOGGER.warn("filesystem_keystore initialized wallet_home={} security_warning=keys_stored_without_encryption recommendation=use_platform_keystore_in_production", (Object)walletHome);
    }

    @Override
    public Optional<byte[]> load(String alias) {
        Path file = this.fileFor(alias);
        if (!Files.exists(file, new LinkOption[0])) {
            return Optional.empty();
        }
        try {
            String data = Files.readString(file, StandardCharsets.UTF_8).trim();
            if (data.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(Base64.getDecoder().decode(data));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read secret from filesystem store", e);
        }
    }

    @Override
    public void store(String alias, byte[] value) {
        Path file = this.fileFor(alias);
        try {
            Files.createDirectories(this.walletHome, new FileAttribute[0]);
            Files.writeString(file, (CharSequence)Base64.getEncoder().encodeToString(value), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to write secret to filesystem store", e);
        }
    }

    private Path fileFor(String alias) {
        String sanitized = alias.replaceAll("[^a-zA-Z0-9_-]", "_");
        return this.walletHome.resolve(sanitized + ".key");
    }
}

