/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.security;

import java.nio.file.Path;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.wallet.core.security.FileSystemSecureKeyStore;
import xyz.tcheeric.wallet.core.security.PlatformSecureKeyStore;

public interface SecureKeyStore {
    public static final Logger LOGGER = LoggerFactory.getLogger(SecureKeyStore.class);

    public Optional<byte[]> load(String var1);

    public void store(String var1, byte[] var2);

    public static SecureKeyStore create(Path walletHome) {
        String password = System.getenv("CASHU_KEYSTORE_PASSWORD");
        if (password != null && !password.isBlank()) {
            try {
                LOGGER.info("secure_keystore initializing_platform_keystore wallet_home={}", (Object)walletHome);
                return new PlatformSecureKeyStore(walletHome, password.toCharArray());
            }
            catch (Exception ex) {
                throw new IllegalStateException("Failed to initialize platform secure keystore; refusing to fallback to filesystem storage", ex);
            }
        }
        LOGGER.warn("secure_keystore fallback_to_filesystem wallet_home={} security_level=LOW reason=no_platform_keystore_password impact=keys_stored_on_disk_with_basic_protection recommendation=set_CASHU_KEYSTORE_PASSWORD_env_var", (Object)walletHome);
        return new FileSystemSecureKeyStore(walletHome);
    }
}

