/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.state;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Objects;
import xyz.tcheeric.wallet.core.state.SchemaVersionDeserializer;
import xyz.tcheeric.wallet.core.state.SchemaVersionSerializer;

@JsonSerialize(using=SchemaVersionSerializer.class)
@JsonDeserialize(using=SchemaVersionDeserializer.class)
public record SchemaVersion(@Min(value=0L) @Min(value=0L) int major, @Min(value=0L) @Min(value=0L) int minor) implements Comparable<SchemaVersion>,
Serializable
{
    public static final SchemaVersion V1_0 = new SchemaVersion(1, 0);
    public static final SchemaVersion V1_1 = new SchemaVersion(1, 1);

    public static SchemaVersion parse(@NotNull String value) {
        Objects.requireNonNull(value, "value");
        String[] parts = value.split("\\.");
        if (parts.length < 2) {
            throw new IllegalArgumentException("Schema version must be in 'major.minor' format: " + value);
        }
        return new SchemaVersion(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]));
    }

    public static SchemaVersion of(int major, int minor) {
        return new SchemaVersion(major, minor);
    }

    public static SchemaVersion latest() {
        return V1_1;
    }

    public static SchemaVersion earliest() {
        return V1_0;
    }

    @Override
    public int compareTo(SchemaVersion other) {
        int majorCompare = Integer.compare(this.major, other.major);
        if (majorCompare != 0) {
            return majorCompare;
        }
        return Integer.compare(this.minor, other.minor);
    }

    @Override
    public String toString() {
        return this.major + "." + this.minor;
    }
}

