/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.state;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.wallet.core.state.MalformedEventException;
import xyz.tcheeric.wallet.core.state.MeltHistoryEvent;
import xyz.tcheeric.wallet.core.state.MintHistoryEvent;
import xyz.tcheeric.wallet.core.state.QuarantinedHistoryEvent;
import xyz.tcheeric.wallet.core.state.RelayMetadata;
import xyz.tcheeric.wallet.core.state.SchemaVersion;
import xyz.tcheeric.wallet.core.state.StoredVoucher;
import xyz.tcheeric.wallet.core.state.SwapHistoryEvent;
import xyz.tcheeric.wallet.core.state.UnknownEventKindException;
import xyz.tcheeric.wallet.core.state.WalletHistoryEvent;
import xyz.tcheeric.wallet.core.state.WalletSchemaMetadata;
import xyz.tcheeric.wallet.core.state.WalletSchemaNegotiator;
import xyz.tcheeric.wallet.core.state.WalletState;
import xyz.tcheeric.wallet.core.state.WalletToken;

class WalletStateDeserializer
extends StdDeserializer<WalletState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WalletStateDeserializer.class);
    private final WalletSchemaNegotiator negotiator = new WalletSchemaNegotiator();

    WalletStateDeserializer() {
        super(WalletState.class);
    }

    @Override
    public WalletState deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        ObjectCodec codec = p.getCodec();
        ObjectNode root = (ObjectNode)codec.readTree(p);
        WalletSchemaMetadata schema = this.parseSchema(root.path("schema"));
        Instant exportedAt = this.parseInstant(root.path("exported_at"), root.path("exportedAt"));
        List<WalletToken> tokens = this.parseTokens(root.path("tokens"));
        ParseHistoryResult history = this.parseHistory(root.path("history"), schema.negotiated());
        ArrayList<QuarantinedHistoryEvent> quarantined = new ArrayList<QuarantinedHistoryEvent>(history.quarantined());
        quarantined.addAll(this.parseQuarantined(root.path("quarantined")));
        List<StoredVoucher> vouchers = this.parseVouchers(root.path("vouchers"));
        this.logUnknownTopLevelFields(root);
        return new WalletState(schema, exportedAt, tokens, history.events(), quarantined, null, null, null, vouchers, null);
    }

    private WalletSchemaMetadata parseSchema(JsonNode node) {
        if (!node.isObject()) {
            SchemaVersion fallback = SchemaVersion.latest();
            return this.negotiator.advertisedMetadata(fallback, fallback, List.of(fallback));
        }
        SchemaVersion advertised = this.readVersion(node, List.of("advertised", "version", "current"), SchemaVersion.latest());
        SchemaVersion minimum = this.readVersion(node, List.of("minimum", "min"), advertised);
        List<SchemaVersion> remoteSupported = this.readVersions(node.path("supported"));
        if (remoteSupported.isEmpty()) {
            remoteSupported = this.readVersions(node.path("remote_supported"));
        }
        if (remoteSupported.isEmpty()) {
            remoteSupported = List.of(advertised);
        }
        WalletSchemaMetadata advertisedMetadata = new WalletSchemaMetadata(advertised, advertised, minimum, remoteSupported, WalletSchemaNegotiator.LOCAL_PREFERENCE);
        return this.negotiator.negotiate(advertisedMetadata);
    }

    private SchemaVersion readVersion(JsonNode node, List<String> fieldNames, SchemaVersion fallback) {
        for (String field : fieldNames) {
            JsonNode valueNode = node.path(field);
            if (!valueNode.isTextual()) continue;
            try {
                return SchemaVersion.parse(valueNode.asText());
            }
            catch (IllegalArgumentException ex) {
                LOGGER.warn("wallet_state schema_field_invalid field={} reason=invalid_format provided={} fallback={}", field, valueNode.asText(), fallback);
            }
        }
        return fallback;
    }

    private List<SchemaVersion> readVersions(JsonNode arrayNode) {
        if (!arrayNode.isArray()) {
            return List.of();
        }
        LinkedHashSet<SchemaVersion> versions = new LinkedHashSet<SchemaVersion>();
        for (JsonNode item : arrayNode) {
            if (!item.isTextual()) continue;
            try {
                versions.add(SchemaVersion.parse(item.asText()));
            }
            catch (IllegalArgumentException ex) {
                LOGGER.warn("wallet_state schema_version_skipped reason=invalid_format value={}", (Object)item.asText());
            }
        }
        return List.copyOf(versions);
    }

    private Instant parseInstant(JsonNode primary, JsonNode secondary) {
        JsonNode source2;
        JsonNode jsonNode = source2 = primary.isMissingNode() || primary.isNull() ? secondary : primary;
        if (source2.isTextual()) {
            try {
                return Instant.parse(source2.asText());
            }
            catch (Exception ex) {
                LOGGER.warn("wallet_state exported_at_invalid reason=invalid_timestamp value={}", (Object)source2.asText());
            }
        }
        return Instant.now();
    }

    private List<WalletToken> parseTokens(JsonNode tokensNode) {
        if (!tokensNode.isArray()) {
            return List.of();
        }
        ArrayList<WalletToken> tokens = new ArrayList<WalletToken>();
        for (JsonNode tokenNode : tokensNode) {
            try {
                tokens.add(this.parseToken(tokenNode));
            }
            catch (IllegalArgumentException ex) {
                LOGGER.warn("wallet_token skipped_invalid reason={} mintUrl={}", (Object)ex.getMessage(), (Object)tokenNode.path("mint_url").asText(tokenNode.path("mintUrl").asText("unknown")));
            }
        }
        return List.copyOf(tokens);
    }

    private WalletToken parseToken(JsonNode tokenNode) {
        if (!tokenNode.isObject()) {
            throw new IllegalArgumentException("token entry must be an object");
        }
        String mintUrl = this.readString(tokenNode, "mint_url", "mintUrl").orElseThrow(() -> new IllegalArgumentException("mint_url is required"));
        String tokenId = this.readString(tokenNode, "token_id", "tokenId").orElseThrow(() -> new IllegalArgumentException("token_id is required"));
        long amount = this.readPositiveLong(tokenNode, "amount");
        String unit = this.readString(tokenNode, "unit").orElse("sat");
        Instant issuedAt = this.readInstant(tokenNode, "issued_at", "issuedAt");
        List<String> proofs = this.readStringArray(tokenNode.path("proofs"));
        RelayMetadata relay = this.parseRelay(tokenNode.path("relay"));
        return new WalletToken(mintUrl, tokenId, amount, unit, issuedAt, proofs, relay);
    }

    private List<StoredVoucher> parseVouchers(JsonNode vouchersNode) {
        if (!vouchersNode.isArray()) {
            return List.of();
        }
        ArrayList<StoredVoucher> vouchers = new ArrayList<StoredVoucher>();
        for (JsonNode voucherNode : vouchersNode) {
            try {
                vouchers.add(this.parseVoucher(voucherNode));
            }
            catch (IllegalArgumentException ex) {
                LOGGER.warn("wallet_voucher skipped_invalid reason={} voucherId={}", (Object)ex.getMessage(), (Object)voucherNode.path("voucherId").asText("unknown"));
            }
        }
        return List.copyOf(vouchers);
    }

    private StoredVoucher parseVoucher(JsonNode voucherNode) {
        if (!voucherNode.isObject()) {
            throw new IllegalArgumentException("voucher entry must be an object");
        }
        String voucherId = this.readString(voucherNode, "voucherId").orElseThrow(() -> new IllegalArgumentException("voucherId is required"));
        String issuerId = this.readString(voucherNode, "issuerId").orElseThrow(() -> new IllegalArgumentException("issuerId is required"));
        String unit = this.readString(voucherNode, "unit").orElse("sat");
        long faceValue = this.readPositiveLong(voucherNode, "faceValue");
        Long expiresAt = voucherNode.path("expiresAt").isNumber() ? Long.valueOf(voucherNode.path("expiresAt").asLong()) : null;
        String memo = this.readString(voucherNode, "memo").orElse(null);
        String issuerSignature = this.readString(voucherNode, "issuerSignature").orElseThrow(() -> new IllegalArgumentException("issuerSignature is required"));
        String issuerPublicKey = this.readString(voucherNode, "issuerPublicKey").orElseThrow(() -> new IllegalArgumentException("issuerPublicKey is required"));
        Instant issuedAt = this.readInstant(voucherNode, "issuedAt");
        String status = this.readString(voucherNode, "status").orElse("issued");
        return new StoredVoucher(voucherId, issuerId, unit, faceValue, expiresAt, memo, issuerSignature, issuerPublicKey, issuedAt, status);
    }

    private List<String> readStringArray(JsonNode node) {
        if (!node.isArray()) {
            throw new IllegalArgumentException("proofs array is required");
        }
        ArrayList<String> values2 = new ArrayList<String>();
        for (JsonNode value : node) {
            if (!value.isTextual()) continue;
            values2.add(value.asText());
        }
        if (values2.isEmpty()) {
            throw new IllegalArgumentException("proofs array cannot be empty");
        }
        return List.copyOf(values2);
    }

    private ParseHistoryResult parseHistory(JsonNode historyNode, SchemaVersion schemaVersion) {
        if (!historyNode.isArray()) {
            return new ParseHistoryResult(List.of(), List.of());
        }
        ArrayList<WalletHistoryEvent> events = new ArrayList<WalletHistoryEvent>();
        ArrayList<QuarantinedHistoryEvent> quarantined = new ArrayList<QuarantinedHistoryEvent>();
        for (JsonNode eventNode : historyNode) {
            try {
                events.add(this.parseHistoryEvent(eventNode, schemaVersion));
            }
            catch (UnknownEventKindException unknown) {
                LOGGER.warn("wallet_history_event skipped_unknown_kind reason=not_supported kind={} schema={} relayUrl={} relayId={}", unknown.kind(), schemaVersion, unknown.relay().url(), unknown.relay().identifier());
                quarantined.add(new QuarantinedHistoryEvent(unknown.relay(), "unknown_kind:" + unknown.kind(), eventNode.toString()));
            }
            catch (MalformedEventException malformed) {
                RelayMetadata relay = malformed.relay() == null ? RelayMetadata.UNKNOWN : malformed.relay();
                LOGGER.warn("wallet_history_event quarantined_malformed reason={} schema={} relayUrl={} relayId={}", malformed.getMessage(), schemaVersion, relay.url(), relay.identifier());
                quarantined.add(new QuarantinedHistoryEvent(relay, "malformed:" + malformed.getMessage(), eventNode.toString()));
            }
        }
        return new ParseHistoryResult(List.copyOf(events), List.copyOf(quarantined));
    }

    private WalletHistoryEvent parseHistoryEvent(JsonNode eventNode, SchemaVersion schemaVersion) {
        if (!eventNode.isObject()) {
            throw new MalformedEventException("event must be an object", RelayMetadata.UNKNOWN);
        }
        String kind = this.readString(eventNode, "kind").orElseThrow(() -> new MalformedEventException("kind missing", this.parseRelay(eventNode.path("relay"))));
        RelayMetadata relay = this.parseRelay(eventNode.path("relay"));
        Instant occurredAt = this.readInstant(eventNode, "occurred_at", "occurredAt");
        try {
            switch (kind.toLowerCase(Locale.ROOT)) {
                case "mint": {
                    long amount = this.readPositiveLong(eventNode, "amount");
                    String unit = this.readString(eventNode, "unit").orElse("sat");
                    String memo = this.readString(eventNode, "memo").orElse(null);
                    return new MintHistoryEvent(relay, occurredAt, amount, unit, memo);
                }
                case "melt": {
                    long amount = this.readPositiveLong(eventNode, "amount");
                    String unit = this.readString(eventNode, "unit").orElse("sat");
                    String invoice = this.readString(eventNode, "invoice").orElseThrow(() -> new MalformedEventException("invoice missing", relay));
                    return new MeltHistoryEvent(relay, occurredAt, amount, unit, invoice);
                }
                case "swap": {
                    long sent = this.readPositiveLong(eventNode, "sent");
                    long received = this.readPositiveLong(eventNode, "received");
                    String unit = this.readString(eventNode, "unit").orElse("sat");
                    return new SwapHistoryEvent(relay, occurredAt, sent, received, unit);
                }
            }
            throw new UnknownEventKindException(kind, relay);
        }
        catch (IllegalArgumentException ex) {
            throw new MalformedEventException(ex.getMessage(), relay);
        }
    }

    private List<QuarantinedHistoryEvent> parseQuarantined(JsonNode node) {
        if (!node.isArray()) {
            return List.of();
        }
        ArrayList<QuarantinedHistoryEvent> quarantined = new ArrayList<QuarantinedHistoryEvent>();
        for (JsonNode entry : node) {
            if (!entry.isObject()) continue;
            RelayMetadata relay = this.parseRelay(entry.path("relay"));
            String reason = this.readString(entry, "reason").orElse("unknown");
            String raw = this.readString(entry, "raw_event", "rawEvent").orElse(entry.toString());
            quarantined.add(new QuarantinedHistoryEvent(relay, reason, raw));
        }
        return List.copyOf(quarantined);
    }

    private Optional<String> readString(JsonNode node, String ... fieldNames) {
        for (String field : fieldNames) {
            JsonNode value = node.path(field);
            if (!value.isTextual()) continue;
            return Optional.of(value.asText());
        }
        return Optional.empty();
    }

    private long readPositiveLong(JsonNode node, String field) {
        JsonNode value = node.path(field);
        if (!value.canConvertToLong()) {
            throw new IllegalArgumentException(field + " must be a positive integer");
        }
        long number = value.asLong();
        if (number <= 0L) {
            throw new IllegalArgumentException(field + " must be a positive integer");
        }
        return number;
    }

    private Instant readInstant(JsonNode node, String ... fieldNames) {
        for (String field : fieldNames) {
            JsonNode value = node.path(field);
            if (!value.isTextual()) continue;
            try {
                return Instant.parse(value.asText());
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(field + " must be an ISO-8601 instant");
            }
        }
        return Instant.now();
    }

    private RelayMetadata parseRelay(JsonNode node) {
        if (!node.isObject()) {
            return RelayMetadata.UNKNOWN;
        }
        String url = this.readString(node, "url").orElse("unknown");
        String identifier = this.readString(node, "identifier", "id").orElse(null);
        String eventId = this.readString(node, "event_id", "eventId").orElse(null);
        return new RelayMetadata(url, identifier, eventId);
    }

    private void logUnknownTopLevelFields(ObjectNode root) {
        Set<String> known = Set.of("schema", "exported_at", "exportedAt", "tokens", "history", "quarantined");
        Iterator<String> fieldNames = root.fieldNames();
        while (fieldNames.hasNext()) {
            String field = fieldNames.next();
            if (known.contains(field)) continue;
            LOGGER.debug("wallet_state field_ignored name={}", (Object)field);
        }
    }

    private record ParseHistoryResult(List<WalletHistoryEvent> events, List<QuarantinedHistoryEvent> quarantined) {
    }
}

