/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.state;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import xyz.tcheeric.wallet.core.state.MeltHistoryEvent;
import xyz.tcheeric.wallet.core.state.MintHistoryEvent;
import xyz.tcheeric.wallet.core.state.QuarantinedHistoryEvent;
import xyz.tcheeric.wallet.core.state.RelayMetadata;
import xyz.tcheeric.wallet.core.state.SchemaVersion;
import xyz.tcheeric.wallet.core.state.StoredVoucher;
import xyz.tcheeric.wallet.core.state.SwapHistoryEvent;
import xyz.tcheeric.wallet.core.state.WalletHistoryEvent;
import xyz.tcheeric.wallet.core.state.WalletSchemaMetadata;
import xyz.tcheeric.wallet.core.state.WalletState;
import xyz.tcheeric.wallet.core.state.WalletToken;

class WalletStateSerializer
extends StdSerializer<WalletState> {
    WalletStateSerializer() {
        super(WalletState.class);
    }

    @Override
    public void serialize(WalletState value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        this.writeSchema(value.schema(), gen);
        gen.writeStringField("exported_at", value.exportedAt().toString());
        gen.writeArrayFieldStart("tokens");
        for (WalletToken token : value.tokens()) {
            this.writeToken(token, gen);
        }
        gen.writeEndArray();
        gen.writeArrayFieldStart("history");
        for (WalletHistoryEvent event : value.history()) {
            this.writeHistoryEvent(event, gen);
        }
        gen.writeEndArray();
        gen.writeArrayFieldStart("quarantined");
        for (QuarantinedHistoryEvent entry : value.quarantined()) {
            this.writeQuarantined(entry, gen);
        }
        gen.writeEndArray();
        gen.writeArrayFieldStart("vouchers");
        for (StoredVoucher voucher : value.vouchers()) {
            this.writeVoucher(voucher, gen);
        }
        gen.writeEndArray();
        gen.writeEndObject();
    }

    private void writeVoucher(StoredVoucher voucher, JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("voucherId", voucher.voucherId());
        gen.writeStringField("issuerId", voucher.issuerId());
        gen.writeStringField("unit", voucher.unit());
        gen.writeNumberField("faceValue", voucher.faceValue());
        if (voucher.expiresAt() != null) {
            gen.writeNumberField("expiresAt", voucher.expiresAt());
        }
        if (voucher.memo() != null) {
            gen.writeStringField("memo", voucher.memo());
        }
        gen.writeStringField("issuerSignature", voucher.issuerSignature());
        gen.writeStringField("issuerPublicKey", voucher.issuerPublicKey());
        gen.writeStringField("issuedAt", voucher.issuedAt().toString());
        gen.writeStringField("status", voucher.status());
        gen.writeEndObject();
    }

    private void writeSchema(WalletSchemaMetadata schema, JsonGenerator gen) throws IOException {
        gen.writeObjectFieldStart("schema");
        gen.writeStringField("negotiated", schema.negotiated().toString());
        gen.writeStringField("advertised", schema.remoteAdvertised().toString());
        gen.writeStringField("minimum", schema.remoteMinimum().toString());
        gen.writeArrayFieldStart("remote_supported");
        for (SchemaVersion version : schema.remoteSupported()) {
            gen.writeString(version.toString());
        }
        gen.writeEndArray();
        gen.writeArrayFieldStart("local_supported");
        for (SchemaVersion version : schema.localSupported()) {
            gen.writeString(version.toString());
        }
        gen.writeEndArray();
        gen.writeEndObject();
    }

    private void writeToken(WalletToken token, JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("mint_url", token.mintUrl());
        gen.writeStringField("token_id", token.tokenId());
        gen.writeNumberField("amount", token.amount());
        gen.writeStringField("unit", token.unit());
        gen.writeStringField("issued_at", token.issuedAt().toString());
        gen.writeArrayFieldStart("proofs");
        for (String proof : token.proofs()) {
            gen.writeString(proof);
        }
        gen.writeEndArray();
        this.writeRelay(token.relay(), gen);
        gen.writeEndObject();
    }

    private void writeRelay(RelayMetadata relay, JsonGenerator gen) throws IOException {
        gen.writeObjectFieldStart("relay");
        gen.writeStringField("url", relay.url());
        if (relay.identifier() != null) {
            gen.writeStringField("identifier", relay.identifier());
        }
        if (relay.eventId() != null) {
            gen.writeStringField("event_id", relay.eventId());
        }
        gen.writeEndObject();
    }

    private void writeHistoryEvent(WalletHistoryEvent event, JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("kind", event.kind());
        gen.writeStringField("occurred_at", event.occurredAt().toString());
        this.writeRelay(event.relay(), gen);
        if (event instanceof MintHistoryEvent) {
            MintHistoryEvent mint = (MintHistoryEvent)event;
            gen.writeNumberField("amount", mint.amount());
            gen.writeStringField("unit", mint.unit());
            if (mint.memo() != null) {
                gen.writeStringField("memo", mint.memo());
            }
        } else if (event instanceof MeltHistoryEvent) {
            MeltHistoryEvent melt = (MeltHistoryEvent)event;
            gen.writeNumberField("amount", melt.amount());
            gen.writeStringField("unit", melt.unit());
            gen.writeStringField("invoice", melt.invoice());
        } else if (event instanceof SwapHistoryEvent) {
            SwapHistoryEvent swap = (SwapHistoryEvent)event;
            gen.writeNumberField("sent", swap.sent());
            gen.writeNumberField("received", swap.received());
            gen.writeStringField("unit", swap.unit());
        }
        gen.writeEndObject();
    }

    private void writeQuarantined(QuarantinedHistoryEvent entry, JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("reason", entry.reason());
        gen.writeStringField("raw_event", entry.rawEvent());
        this.writeRelay(entry.relay(), gen);
        gen.writeEndObject();
    }
}

