/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.token;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public record TokenEnvelope(String mintUrl, String unit, List<TokenProof> proofs) {
    public TokenEnvelope {
        Objects.requireNonNull(mintUrl, "mintUrl");
        Objects.requireNonNull(unit, "unit");
        Objects.requireNonNull(proofs, "proofs");
        proofs = List.copyOf(proofs);
    }

    public record TokenProof(int amount, String cHex, byte[] secret, String keysetId) {
        private final byte[] secret;

        public TokenProof {
            if (amount <= 0) {
                throw new IllegalArgumentException("amount must be positive");
            }
            Objects.requireNonNull(cHex, "cHex");
            secret = secret == null ? new byte[]{} : Arrays.copyOf(secret, secret.length);
        }

        public byte[] secret() {
            return Arrays.copyOf(this.secret, this.secret.length);
        }
    }
}

