/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.validation;

import java.util.Arrays;

final class Bech32 {
    private static final String CHARSET = "qpzry9x8gf2tvdw0s3jn54khce6mua7l";
    private static final int[] CHARSET_REV = new int[128];
    private static final int[] GENERATORS = new int[]{996825010, 642813549, 513874426, 1027748829, 705979059};

    private Bech32() {
    }

    static boolean containsOnlyCharset(String data) {
        for (int i2 = 0; i2 < data.length(); ++i2) {
            char ch = data.charAt(i2);
            if (ch < CHARSET_REV.length && CHARSET_REV[ch] >= 0) continue;
            return false;
        }
        return true;
    }

    static boolean hasValidChecksum(String hrp, String data) {
        int[] values2 = new int[data.length()];
        for (int i2 = 0; i2 < data.length(); ++i2) {
            char ch = data.charAt(i2);
            if (ch >= CHARSET_REV.length || CHARSET_REV[ch] < 0) {
                return false;
            }
            values2[i2] = CHARSET_REV[ch];
        }
        return Bech32.polymod(Bech32.hrpExpand(hrp), values2) == 1;
    }

    private static int[] hrpExpand(String hrp) {
        int i2;
        int[] expanded = new int[hrp.length() * 2 + 1];
        int idx = 0;
        for (i2 = 0; i2 < hrp.length(); ++i2) {
            expanded[idx++] = hrp.charAt(i2) >> 5;
        }
        expanded[idx++] = 0;
        for (i2 = 0; i2 < hrp.length(); ++i2) {
            expanded[idx++] = hrp.charAt(i2) & 0x1F;
        }
        return expanded;
    }

    private static int polymod(int[] hrpExpanded, int[] values2) {
        int chk = 1;
        for (int v : Bech32.concatenate(hrpExpanded, values2)) {
            int top = chk >>> 25;
            chk = (chk & 0x1FFFFFF) << 5 ^ v;
            for (int i2 = 0; i2 < GENERATORS.length; ++i2) {
                if ((top >>> i2 & 1) != 1) continue;
                chk ^= GENERATORS[i2];
            }
        }
        return chk;
    }

    private static int[] concatenate(int[] a, int[] b) {
        int[] result = Arrays.copyOf(a, a.length + b.length);
        System.arraycopy(b, 0, result, a.length, b.length);
        return result;
    }

    static {
        Arrays.fill(CHARSET_REV, -1);
        for (int i2 = 0; i2 < CHARSET.length(); ++i2) {
            Bech32.CHARSET_REV[CHARSET.charAt((int)i2)] = i2;
        }
    }
}

