/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.validation;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.Currency;
import java.util.Locale;
import java.util.Set;
import xyz.tcheeric.wallet.core.validation.CashuUnit;

public final class CashuUnitValidator
implements ConstraintValidator<CashuUnit, String> {
    private static final Set<String> SPECIAL_UNITS = Set.of("sat", "msat", "btc", "auth");

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        String trimmed = value.trim();
        if (trimmed.isEmpty() || !trimmed.equals(value)) {
            return false;
        }
        String normalized = trimmed.toLowerCase(Locale.ROOT);
        if (SPECIAL_UNITS.contains(normalized)) {
            return true;
        }
        if (trimmed.length() == 3) {
            try {
                Currency.getInstance(trimmed.toUpperCase(Locale.ROOT));
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return normalized.matches("[a-z]{3,12}");
    }
}

