/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.validation;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.net.URI;
import java.util.Locale;
import xyz.tcheeric.wallet.core.validation.MintUrl;

public final class MintUrlValidator
implements ConstraintValidator<MintUrl, String> {
    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        String trimmed = value.trim();
        if (trimmed.isEmpty() || !trimmed.equals(value)) {
            return false;
        }
        try {
            URI uri = URI.create(trimmed);
            String scheme = uri.getScheme();
            if (scheme == null) {
                return false;
            }
            String normalizedScheme = scheme.toLowerCase(Locale.ROOT);
            if (!normalizedScheme.equals("http") && !normalizedScheme.equals("https")) {
                return false;
            }
            String host = uri.getHost();
            return host != null && !host.isBlank();
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

