/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.validation;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.util.Objects;
import java.util.Set;

public final class WalletRequestValidator {
    private static final ValidatorFactory FACTORY = Validation.buildDefaultValidatorFactory();
    private final Validator validator;

    private WalletRequestValidator(Validator validator) {
        this.validator = Objects.requireNonNull(validator, "validator");
    }

    public static WalletRequestValidator usingDefaultProvider() {
        return new WalletRequestValidator(FACTORY.getValidator());
    }

    public <T> T validate(T value) {
        if (value == null) {
            return null;
        }
        Set<ConstraintViolation<T>> violations = this.validator.validate(value, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException("Wallet request validation failed", violations);
        }
        return value;
    }
}

