/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.storage.file;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.wallet.core.StoragePaths;

public class BalanceFileRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BalanceFileRepository.class);

    public Map<String, Long> loadTotals() {
        Properties props = this.loadProperties();
        return this.parseUnitTotals(props);
    }

    private Properties loadProperties() {
        Properties balanceProperties = new Properties();
        if (Files.exists(StoragePaths.balanceFile(), new LinkOption[0])) {
            try (FileInputStream inputStream2 = new FileInputStream(StoragePaths.balanceFile().toFile());){
                log.debug("Loading balance from {}", (Object)StoragePaths.balanceFile());
                balanceProperties.load(inputStream2);
            }
            catch (IOException e) {
                log.error("Failed to read balance from {}", (Object)StoragePaths.balanceFile(), (Object)e);
                throw new RuntimeException("Failed to read balance file. I/O error while reading " + String.valueOf(StoragePaths.balanceFile()) + ". Suggestion: Check file permissions and retry.", e);
            }
        }
        return balanceProperties;
    }

    private Map<String, Long> parseUnitTotals(Properties balanceProperties) {
        HashMap<String, Long> totals = new HashMap<String, Long>();
        for (String key : balanceProperties.stringPropertyNames()) {
            if (!key.startsWith("unit.")) continue;
            String unit = key.substring("unit.".length());
            String val = balanceProperties.getProperty(key, "0");
            try {
                totals.put(unit, Long.parseLong(val));
            }
            catch (NumberFormatException e) {
                log.warn("Skipping invalid balance entry {}={}", (Object)key, (Object)val);
            }
        }
        return totals;
    }

    public void createFileIfMissing(String defaultUnit, List<String> supportedUnits) {
        if (Files.exists(StoragePaths.balanceFile(), new LinkOption[0])) {
            return;
        }
        Properties balanceProperties = new Properties();
        String unit = BalanceFileRepository.chooseInitialUnit(defaultUnit, supportedUnits);
        balanceProperties.setProperty("unit." + unit, "0");
        try (FileOutputStream outputStream2 = new FileOutputStream(StoragePaths.balanceFile().toFile());){
            balanceProperties.store(outputStream2, "cashu-client balance");
            log.debug("Initialized balance file at {}", (Object)StoragePaths.balanceFile());
        }
        catch (IOException e) {
            log.error("Failed to init balance at {}", (Object)StoragePaths.balanceFile(), (Object)e);
            throw new RuntimeException("Failed to initialize balance file. I/O error while writing " + String.valueOf(StoragePaths.balanceFile()) + ". Suggestion: Ensure the directory exists and is writable, then retry.", e);
        }
    }

    private static String chooseInitialUnit(String desired, List<String> supported) {
        if (desired != null && !desired.isBlank()) {
            if (supported != null && !supported.isEmpty()) {
                for (String supportedUnit : supported) {
                    if (!supportedUnit.equalsIgnoreCase(desired)) continue;
                    return supportedUnit;
                }
            }
            return desired;
        }
        if (supported != null && !supported.isEmpty()) {
            return supported.get(0);
        }
        return "sat";
    }
}

