/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.storage.file;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Properties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.wallet.core.StoragePaths;
import xyz.tcheeric.wallet.core.WalletConfig;

public class ConfigFileRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigFileRepository.class);

    public void save(WalletConfig config) {
        Properties configProperties = new Properties();
        configProperties.setProperty("defaultMintUrl", config.defaultMintUrl());
        configProperties.setProperty("defaultUnit", config.defaultUnit());
        try (FileOutputStream outputStream2 = new FileOutputStream(StoragePaths.configFile().toFile());){
            configProperties.store(outputStream2, "cashu-client config");
            log.debug("Config written to {}", (Object)StoragePaths.configFile());
        }
        catch (IOException e) {
            log.error("Failed to write config to {}", (Object)StoragePaths.configFile(), (Object)e);
            throw new RuntimeException("Failed to write wallet config. I/O error while writing " + String.valueOf(StoragePaths.configFile()) + ". Suggestion: Ensure the directory exists and is writable, then retry.", e);
        }
    }

    public Properties load() {
        Properties configProperties = new Properties();
        if (Files.exists(StoragePaths.configFile(), new LinkOption[0])) {
            try (FileInputStream inputStream2 = new FileInputStream(StoragePaths.configFile().toFile());){
                configProperties.load(inputStream2);
            }
            catch (IOException e) {
                log.error("Failed to read config from {}", (Object)StoragePaths.configFile(), (Object)e);
                throw new RuntimeException("Failed to read wallet config. I/O error while reading " + String.valueOf(StoragePaths.configFile()) + ". Suggestion: Check file permissions and retry.", e);
            }
        }
        return configProperties;
    }
}

