/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.storage.file;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.wallet.core.StoragePaths;
import xyz.tcheeric.wallet.core.ports.WalletStorage;
import xyz.tcheeric.wallet.core.state.WalletState;
import xyz.tcheeric.wallet.core.state.WalletStateModule;

public class FileWalletStorage
implements WalletStorage {
    private static final Logger log = LoggerFactory.getLogger(FileWalletStorage.class);
    private final Path storageDir;
    private final ObjectMapper objectMapper;

    public FileWalletStorage() {
        this(StoragePaths.walletHome());
    }

    public FileWalletStorage(Path storageDir) {
        this.storageDir = storageDir;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.registerModule(new JavaTimeModule());
        this.objectMapper.registerModule(new WalletStateModule());
        this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        this.objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        try {
            Files.createDirectories(storageDir, new FileAttribute[0]);
            log.debug("file_wallet_storage initialized storage_dir={}", (Object)storageDir);
        }
        catch (IOException e) {
            throw new WalletStorage.StorageException("Failed to create storage directory: " + String.valueOf(storageDir), e);
        }
    }

    @Override
    public Optional<WalletState> load(String walletId) {
        Path stateFile = this.getStateFile(walletId);
        if (!Files.exists(stateFile, new LinkOption[0])) {
            log.info("file_wallet_storage load_empty wallet_id={} file={}", (Object)walletId, (Object)stateFile);
            return Optional.empty();
        }
        try {
            WalletState state = this.objectMapper.readValue(stateFile.toFile(), WalletState.class);
            log.info("file_wallet_storage load_success wallet_id={} file={} vouchers={} tokens={}", walletId, stateFile, state.vouchers().size(), state.tokens().size());
            return Optional.of(state);
        }
        catch (IOException e) {
            log.error("file_wallet_storage load_failed wallet_id={} file={} error={}", walletId, stateFile, e.getMessage(), e);
            throw new WalletStorage.StorageException("Failed to load wallet state from: " + String.valueOf(stateFile), e);
        }
    }

    @Override
    public void save(String walletId, WalletState state) {
        Path stateFile = this.getStateFile(walletId);
        Path tempFile = stateFile.resolveSibling(String.valueOf(stateFile.getFileName()) + ".tmp");
        try {
            this.objectMapper.writeValue(tempFile.toFile(), (Object)state);
            Files.move(tempFile, stateFile, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            log.info("file_wallet_storage save_success wallet_id={} file={} vouchers={} tokens={}", walletId, stateFile, state.vouchers().size(), state.tokens().size());
        }
        catch (IOException e) {
            log.error("file_wallet_storage save_failed wallet_id={} file={} error={}", walletId, stateFile, e.getMessage(), e);
            try {
                Files.deleteIfExists(tempFile);
            }
            catch (IOException cleanupError) {
                log.warn("file_wallet_storage temp_file_cleanup_failed file={}", (Object)tempFile);
            }
            throw new WalletStorage.StorageException("Failed to save wallet state to: " + String.valueOf(stateFile), e);
        }
    }

    @Override
    public boolean delete(String walletId) {
        Path stateFile = this.getStateFile(walletId);
        try {
            boolean deleted = Files.deleteIfExists(stateFile);
            log.debug("file_wallet_storage delete wallet_id={} deleted={} file={}", walletId, deleted, stateFile);
            return deleted;
        }
        catch (IOException e) {
            log.error("file_wallet_storage delete_failed wallet_id={} file={} error={}", walletId, stateFile, e.getMessage(), e);
            throw new WalletStorage.StorageException("Failed to delete wallet state: " + String.valueOf(stateFile), e);
        }
    }

    @Override
    public boolean exists(String walletId) {
        Path stateFile = this.getStateFile(walletId);
        boolean exists = Files.exists(stateFile, new LinkOption[0]);
        log.debug("file_wallet_storage exists_check wallet_id={} exists={} file={}", walletId, exists, stateFile);
        return exists;
    }

    @Override
    public String getStorageInfo() {
        return "File[" + String.valueOf(this.storageDir) + "]";
    }

    private Path getStateFile(String walletId) {
        String safeFileName = walletId.replaceAll("[^a-zA-Z0-9-_]", "_");
        return this.storageDir.resolve("wallet-state-" + safeFileName + ".json");
    }
}

