-- Schema v1: minimal tables for balances and future features
CREATE TABLE IF NOT EXISTS tokens (
    id BIGINT GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY,
    mint_url VARCHAR(512),
    unit VARCHAR(32) NOT NULL,
    amount BIGINT NOT NULL,
    spent BOOLEAN NOT NULL DEFAULT FALSE,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    spent_at TIMESTAMP
);

CREATE TABLE IF NOT EXISTS keysets (
    id VARCHAR(64) PRIMARY KEY,
    mint_url VARCHAR(512),
    unit VARCHAR(32),
    pubkeys_json TEXT,
    active BOOLEAN DEFAULT TRUE,
    rotated_at TIMESTAMP
);

CREATE TABLE IF NOT EXISTS mints (
    url VARCHAR(512) PRIMARY KEY,
    meta_json TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE IF NOT EXISTS history (
    id BIGINT GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY,
    type VARCHAR(32) NOT NULL,
    amount BIGINT NOT NULL,
    unit VARCHAR(32) NOT NULL,
    mint_url VARCHAR(512),
    ref VARCHAR(256),
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);
