/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Positive;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import xyz.tcheeric.wallet.core.BalanceService;
import xyz.tcheeric.wallet.core.domain.events.DomainEvent;
import xyz.tcheeric.wallet.core.exception.WalletOperationException;
import xyz.tcheeric.wallet.core.proof.ProofRecord;
import xyz.tcheeric.wallet.core.validation.Bolt11;
import xyz.tcheeric.wallet.core.validation.CashuUnit;
import xyz.tcheeric.wallet.core.validation.MintUrl;

public interface SendService
extends BalanceService {
    public SendLightningResult sendLightning(SendLightningRequest var1) throws WalletOperationException;

    public PreparedP2pkSend prepareP2pkSend(P2pkSendRequest var1);

    public static class PreparedP2pkSend {
        private final List<ProofRecord> proofs;
        private final long totalAmount;
        private final Runnable commitAction;
        private final Runnable cancelAction;
        private final List<DomainEvent> uncommittedEvents;

        public PreparedP2pkSend(List<ProofRecord> proofs, long totalAmount, Runnable commitAction, Runnable cancelAction) {
            this(proofs, totalAmount, commitAction, cancelAction, Collections.emptyList());
        }

        public PreparedP2pkSend(List<ProofRecord> proofs, long totalAmount, Runnable commitAction, Runnable cancelAction, List<DomainEvent> uncommittedEvents) {
            this.proofs = List.copyOf(proofs);
            this.totalAmount = totalAmount;
            this.commitAction = commitAction != null ? commitAction : () -> {};
            this.cancelAction = cancelAction != null ? cancelAction : () -> {};
            this.uncommittedEvents = new ArrayList<DomainEvent>(uncommittedEvents != null ? uncommittedEvents : Collections.emptyList());
        }

        public List<ProofRecord> proofs() {
            return this.proofs;
        }

        public long totalAmount() {
            return this.totalAmount;
        }

        public List<DomainEvent> getUncommittedEvents() {
            return Collections.unmodifiableList(this.uncommittedEvents);
        }

        public void commit() {
            this.commitAction.run();
        }

        public void cancel() {
            this.cancelAction.run();
        }
    }

    public record P2pkSendRequest(@Positive long amount, @CashuUnit String unit, @MintUrl String mintUrl) {
        public P2pkSendRequest(@Positive long amount, @CashuUnit String unit, @MintUrl String mintUrl) {
            Objects.requireNonNull(unit, "unit");
            Objects.requireNonNull(mintUrl, "mintUrl");
            if (amount <= 0L) {
                throw new IllegalArgumentException("amount must be positive");
            }
        }
    }

    public record SendLightningResult(LightningStatus status, String message) {
        public boolean isSuccess() {
            return this.status == LightningStatus.SUCCESS;
        }

        public static enum LightningStatus {
            SUCCESS,
            QUOTE_EXPIRED,
            LIGHTNING_FAILURE,
            INVALID_CHANGE;

        }
    }

    public record SendLightningRequest(@Positive long amount, @CashuUnit String unit, @MintUrl String mintUrl, @NotBlank @Bolt11 String invoice) {
        public SendLightningRequest(@Positive long amount, @CashuUnit String unit, @MintUrl String mintUrl, @NotBlank @Bolt11 String invoice) {
            Objects.requireNonNull(unit, "unit");
            Objects.requireNonNull(mintUrl, "mintUrl");
            Objects.requireNonNull(invoice, "invoice");
            if (amount <= 0L) {
                throw new IllegalArgumentException("amount must be positive");
            }
            if (invoice.isBlank()) {
                throw new IllegalArgumentException("invoice must not be blank");
            }
        }
    }
}

