/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Positive;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import xyz.tcheeric.wallet.core.BalanceService;
import xyz.tcheeric.wallet.core.exception.WalletOperationException;
import xyz.tcheeric.wallet.core.state.StoredVoucher;
import xyz.tcheeric.wallet.core.validation.CashuUnit;

public interface VoucherService
extends BalanceService {
    public IssueVoucherResult issueAndBackup(IssueVoucherRequest var1) throws WalletOperationException;

    public List<StoredVoucher> listVouchers();

    public Optional<StoredVoucher> getVoucher(String var1);

    public void backupToNostr() throws WalletOperationException;

    public int restoreFromNostr() throws WalletOperationException;

    public Optional<StoredVoucher> refreshStatus(String var1) throws WalletOperationException;

    public void importVoucher(StoredVoucher var1) throws WalletOperationException;

    public RedeemVoucherResult redeemVoucher(RedeemVoucherRequest var1) throws WalletOperationException;

    public RevokeVoucherResult revokeVoucher(RevokeVoucherRequest var1) throws WalletOperationException;

    public VerifyVoucherResult verifyVoucher(VerifyVoucherRequest var1) throws WalletOperationException;

    public record VerifyVoucherResult(@NotBlank String voucherId, boolean signatureValid, boolean expired, @NotBlank String status, @NotBlank String message) {
        public VerifyVoucherResult(@NotBlank String voucherId, boolean signatureValid, boolean expired, @NotBlank String status, @NotBlank String message) {
            Objects.requireNonNull(voucherId, "voucherId");
            Objects.requireNonNull(status, "status");
            Objects.requireNonNull(message, "message");
        }

        public boolean isValid() {
            return this.signatureValid && !this.expired && "issued".equals(this.status);
        }
    }

    public record VerifyVoucherRequest(@NotBlank String voucherId) {
        public VerifyVoucherRequest(@NotBlank String voucherId) {
            Objects.requireNonNull(voucherId, "voucherId");
        }
    }

    public record RevokeVoucherResult(@NotBlank String voucherId, @NotBlank String previousStatus, @NotBlank String message, boolean ledgerPublished) {
        public RevokeVoucherResult(@NotBlank String voucherId, @NotBlank String previousStatus, @NotBlank String message, boolean ledgerPublished) {
            Objects.requireNonNull(voucherId, "voucherId");
            Objects.requireNonNull(previousStatus, "previousStatus");
            Objects.requireNonNull(message, "message");
        }
    }

    public record RevokeVoucherRequest(@NotBlank String voucherId, @NotBlank String reason, boolean publishToLedger) {
        public RevokeVoucherRequest(@NotBlank String voucherId, @NotBlank String reason, boolean publishToLedger) {
            Objects.requireNonNull(voucherId, "voucherId");
            Objects.requireNonNull(reason, "reason");
        }

        public RevokeVoucherRequest(String voucherId, String reason) {
            this(voucherId, reason, true);
        }
    }

    public record RedeemVoucherResult(@NotBlank String voucherId, @NotBlank String status, @NotBlank String message, boolean ledgerVerified, boolean ledgerUpdated) {
        public RedeemVoucherResult(@NotBlank String voucherId, @NotBlank String status, @NotBlank String message, boolean ledgerVerified, boolean ledgerUpdated) {
            Objects.requireNonNull(voucherId, "voucherId");
            Objects.requireNonNull(status, "status");
            Objects.requireNonNull(message, "message");
        }
    }

    public record RedeemVoucherRequest(@NotBlank String voucherId, boolean verifyLedger) {
        public RedeemVoucherRequest(@NotBlank String voucherId, boolean verifyLedger) {
            Objects.requireNonNull(voucherId, "voucherId");
        }

        public RedeemVoucherRequest(String voucherId) {
            this(voucherId, true);
        }
    }

    public record IssueVoucherResult(@NotNull StoredVoucher voucher, @NotBlank String token, boolean backedUp, String message) {
        public IssueVoucherResult(@NotNull StoredVoucher voucher, @NotBlank String token, boolean backedUp, String message) {
            Objects.requireNonNull(voucher, "voucher");
            Objects.requireNonNull(token, "token");
        }
    }

    public record IssueVoucherRequest(@Positive long amount, @NotBlank @CashuUnit String unit, @NotBlank String mintUrl, Integer expiresInDays, String memo) {
        public IssueVoucherRequest(@Positive long amount, @NotBlank @CashuUnit String unit, @NotBlank String mintUrl, Integer expiresInDays, String memo) {
            Objects.requireNonNull(unit, "unit");
            Objects.requireNonNull(mintUrl, "mintUrl");
            if (amount <= 0L) {
                throw new IllegalArgumentException("amount must be positive");
            }
            if (expiresInDays != null && expiresInDays <= 0) {
                throw new IllegalArgumentException("expiresInDays must be positive");
            }
        }
    }
}

