/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.application;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import xyz.tcheeric.wallet.core.SendService;
import xyz.tcheeric.wallet.core.WalletConfig;
import xyz.tcheeric.wallet.core.domain.events.DomainEvent;
import xyz.tcheeric.wallet.core.exception.WalletOperationException;
import xyz.tcheeric.wallet.core.token.TokenDecodingException;

public interface SendUseCase {
    public PayLightningResult payLightning(PayLightningCommand var1) throws WalletOperationException;

    public DeliverP2pkResult deliverP2pk(DeliverP2pkCommand var1) throws WalletOperationException, TokenDecodingException;

    public static enum AttemptStatus {
        SUCCESS,
        FAILED,
        SKIPPED;

    }

    public record RelayAttempt(List<String> relays, AttemptStatus status, String errorMessage) {
        public RelayAttempt {
            status = Objects.requireNonNull(status, "status");
            relays = relays == null ? List.of() : Collections.unmodifiableList(new ArrayList<String>(relays));
        }

        public boolean isSuccess() {
            return this.status == AttemptStatus.SUCCESS;
        }
    }

    public record DeliverP2pkResult(boolean nostrDelivered, boolean tokenGenerated, String token, String eventId, List<RelayAttempt> attempts, int proofCount, long totalAmount, String mintUrl, String unit, String recipient, List<DomainEvent> events) {
        public DeliverP2pkResult {
            attempts = attempts == null ? List.of() : Collections.unmodifiableList(new ArrayList<RelayAttempt>(attempts));
            mintUrl = Objects.requireNonNull(mintUrl, "mintUrl");
            unit = Objects.requireNonNull(unit, "unit");
            recipient = Objects.requireNonNull(recipient, "recipient");
            if (totalAmount < 0L) {
                throw new IllegalArgumentException("totalAmount must be non-negative");
            }
            if (proofCount < 0) {
                throw new IllegalArgumentException("proofCount must be non-negative");
            }
            events = events == null ? List.of() : Collections.unmodifiableList(new ArrayList<DomainEvent>(events));
        }

        public boolean deliveredOrGeneratedToken() {
            return this.nostrDelivered || this.tokenGenerated;
        }
    }

    public record DeliverP2pkCommand(WalletConfig walletConfig, long amount, String recipient, List<String> relayUrls, boolean tokenFallbackEnabled) {
        public DeliverP2pkCommand {
            Objects.requireNonNull(walletConfig, "walletConfig");
            Objects.requireNonNull(recipient, "recipient");
            if (amount <= 0L) {
                throw new IllegalArgumentException("amount must be positive");
            }
            if (recipient.isBlank()) {
                throw new IllegalArgumentException("recipient must not be blank");
            }
            relayUrls = relayUrls == null ? List.of() : List.copyOf(relayUrls);
        }

        public boolean hasRelayPreference() {
            return !this.relayUrls.isEmpty();
        }
    }

    public record PayLightningResult(SendService.SendLightningResult.LightningStatus status, String message, List<DomainEvent> events) {
        public PayLightningResult {
            Objects.requireNonNull(status, "status");
            events = events == null ? List.of() : Collections.unmodifiableList(new ArrayList<DomainEvent>(events));
        }

        public boolean isSuccess() {
            return this.status == SendService.SendLightningResult.LightningStatus.SUCCESS;
        }
    }

    public record PayLightningCommand(WalletConfig walletConfig, long amount, String invoice) {
        public PayLightningCommand {
            Objects.requireNonNull(walletConfig, "walletConfig");
            Objects.requireNonNull(invoice, "invoice");
            if (amount <= 0L) {
                throw new IllegalArgumentException("amount must be positive");
            }
            if (invoice.isBlank()) {
                throw new IllegalArgumentException("invoice must not be blank");
            }
        }

        public SendService.SendLightningRequest toRequest() {
            return new SendService.SendLightningRequest(this.amount, this.walletConfig.defaultUnit(), this.walletConfig.defaultMintUrl(), this.invoice);
        }
    }
}

